"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var OuiaUtils_1 = require("@kogito-apps/ouia-tools/dist/utils/OuiaUtils");
var process_definition_list_1 = require("@kogito-apps/process-definition-list");
var ProcessDefinitionList_1 = require("../../../channel/ProcessDefinitionList");
var react_router_dom_1 = require("react-router-dom");
var DevUIAppContext_1 = require("../../contexts/DevUIAppContext");
var CloudEventFormPage_1 = require("../../pages/CloudEventFormPage/CloudEventFormPage");
var ProcessDefinitionListContainer = function (_a) {
    var ouiaId = _a.ouiaId, ouiaSafe = _a.ouiaSafe;
    var history = (0, react_router_dom_1.useHistory)();
    var gatewayApi = (0, ProcessDefinitionList_1.useProcessDefinitionListGatewayApi)();
    var appContext = (0, DevUIAppContext_1.useDevUIAppContext)();
    (0, react_1.useEffect)(function () {
        var onOpenProcess = {
            onOpen: function (processDefinition) {
                history.push({
                    pathname: "ProcessDefinition/Form/".concat(processDefinition.processName),
                    state: {
                        processDefinition: processDefinition
                    }
                });
            }
        };
        var onOpenWorkflow = {
            onOpen: function (processDefinition) {
                history.push({
                    pathname: "WorkflowDefinition/Form/".concat(processDefinition.processName),
                    state: {
                        workflowDefinition: {
                            workflowName: processDefinition.processName,
                            endpoint: processDefinition.endpoint
                        }
                    }
                });
            }
        };
        var onOpenInstanceUnsubscriber = gatewayApi.onOpenProcessFormListen(appContext.isWorkflow() ? onOpenWorkflow : onOpenProcess);
        var onTriggerCloudEventUnsubscriber = appContext.isWorkflow()
            ? gatewayApi.onOpenTriggerCloudEventListen({
                onOpen: function () {
                    history.push({
                        pathname: "/WorkflowDefinitions/CloudEvent",
                        state: {
                            source: CloudEventFormPage_1.CloudEventPageSource.DEFINITIONS
                        }
                    });
                }
            })
            : undefined;
        return function () {
            onOpenInstanceUnsubscriber.unSubscribe();
            onTriggerCloudEventUnsubscriber === null || onTriggerCloudEventUnsubscriber === void 0 ? void 0 : onTriggerCloudEventUnsubscriber.unSubscribe();
        };
    }, []);
    return ((0, jsx_runtime_1.jsx)(process_definition_list_1.EmbeddedProcessDefinitionList, __assign({}, (0, OuiaUtils_1.componentOuiaProps)(ouiaId, 'process-definition-list-container', ouiaSafe), { driver: gatewayApi, targetOrigin: appContext.getDevUIUrl(), singularProcessLabel: appContext.customLabels.singularProcessLabel, isTriggerCloudEventEnabled: appContext.isWorkflow() })));
};
exports.default = ProcessDefinitionListContainer;
//# sourceMappingURL=ProcessDefinitionListContainer.js.map