"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var custom_dashboard_list_1 = require("@kogito-apps/custom-dashboard-list");
var CustomDashboardListContext_1 = require("../../../channel/CustomDashboardList/CustomDashboardListContext");
var react_router_dom_1 = require("react-router-dom");
var CustomDashboardListContainer = function () {
    var history = (0, react_router_dom_1.useHistory)();
    var gatewayApi = (0, CustomDashboardListContext_1.useCustomDashboardListGatewayApi)();
    (0, react_1.useEffect)(function () {
        var unsubscriber = gatewayApi.onOpenCustomDashboardListen({
            onOpen: function (customDashboardInfo) {
                history.push({
                    pathname: "/customDashboard/".concat(customDashboardInfo.name),
                    state: {
                        filter: gatewayApi.getCustomDashboardFilter(),
                        data: customDashboardInfo
                    }
                });
            }
        });
        return function () {
            unsubscriber.unSubscribe();
        };
    }, []);
    return (0, jsx_runtime_1.jsx)(custom_dashboard_list_1.EmbeddedCustomDashboardList, { driver: gatewayApi, targetOrigin: '*' });
};
exports.default = CustomDashboardListContainer;
//# sourceMappingURL=CustomDashboardListContainer.js.map