"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var react_router_dom_1 = require("react-router-dom");
var react_apollo_1 = require("react-apollo");
var react_router_1 = require("react-router");
var PageLayout_1 = __importDefault(require("@kogito-apps/consoles-common/dist/components/layout/PageLayout/PageLayout"));
var DevUINav_1 = __importDefault(require("../DevUINav/DevUINav"));
var JobsManagementContextProvider_1 = __importDefault(require("../../../channel/JobsManagement/JobsManagementContextProvider"));
var ProcessDetailsContextProvider_1 = __importDefault(require("../../../channel/ProcessDetails/ProcessDetailsContextProvider"));
var ProcessListContextProvider_1 = __importDefault(require("../../../channel/ProcessList/ProcessListContextProvider"));
var TaskInboxContextProvider_1 = __importDefault(require("../../../channel/TaskInbox/TaskInboxContextProvider"));
var TaskFormContextProvider_1 = __importDefault(require("../../../channel/TaskForms/TaskFormContextProvider"));
var FormsListContextProvider_1 = __importDefault(require("../../../channel/FormsList/FormsListContextProvider"));
var FormDetailsContextProvider_1 = __importDefault(require("../../../channel/FormDetails/FormDetailsContextProvider"));
var DevUIAppContextProvider_1 = __importDefault(require("../../contexts/DevUIAppContextProvider"));
var ProcessDefinitionListContextProvider_1 = __importDefault(require("../../../channel/ProcessDefinitionList/ProcessDefinitionListContextProvider"));
var ProcessFormContextProvider_1 = __importDefault(require("../../../channel/ProcessForm/ProcessFormContextProvider"));
var WorkflowFormContextProvider_1 = __importDefault(require("../../../channel/WorkflowForm/WorkflowFormContextProvider"));
var CustomDashboardListContextProvider_1 = __importDefault(require("../../../channel/CustomDashboardList/CustomDashboardListContextProvider"));
var CustomDashboardView_1 = require("../../../channel/CustomDashboardView");
var CloudEventFormContextProvider_1 = __importDefault(require("../../../channel/CloudEventForm/CloudEventFormContextProvider"));
var DevUILayout = function (_a) {
    var apolloClient = _a.apolloClient, isProcessEnabled = _a.isProcessEnabled, isTracingEnabled = _a.isTracingEnabled, users = _a.users, devUIUrl = _a.devUIUrl, openApiPath = _a.openApiPath, availablePages = _a.availablePages, customLabels = _a.customLabels, omittedProcessTimelineEvents = _a.omittedProcessTimelineEvents, diagramPreviewSize = _a.diagramPreviewSize, isStunnerEnabled = _a.isStunnerEnabled, children = _a.children;
    var renderPage = function (routeProps) {
        return ((0, jsx_runtime_1.jsx)(PageLayout_1.default, __assign({ pageNavOpen: true, withHeader: false, PageNav: (0, jsx_runtime_1.jsx)(DevUINav_1.default, { pathname: routeProps.location.pathname }) }, { children: children })));
    };
    return ((0, jsx_runtime_1.jsx)(react_apollo_1.ApolloProvider, __assign({ client: apolloClient }, { children: (0, jsx_runtime_1.jsx)(DevUIAppContextProvider_1.default, __assign({ users: users, devUIUrl: devUIUrl, openApiPath: openApiPath, isProcessEnabled: isProcessEnabled, isTracingEnabled: isTracingEnabled, availablePages: availablePages, customLabels: customLabels, omittedProcessTimelineEvents: omittedProcessTimelineEvents, diagramPreviewSize: diagramPreviewSize, isStunnerEnabled: isStunnerEnabled }, { children: (0, jsx_runtime_1.jsx)(TaskInboxContextProvider_1.default, __assign({ apolloClient: apolloClient }, { children: (0, jsx_runtime_1.jsx)(TaskFormContextProvider_1.default, { children: (0, jsx_runtime_1.jsx)(ProcessListContextProvider_1.default, __assign({ apolloClient: apolloClient }, { children: (0, jsx_runtime_1.jsx)(ProcessDetailsContextProvider_1.default, __assign({ apolloClient: apolloClient }, { children: (0, jsx_runtime_1.jsx)(JobsManagementContextProvider_1.default, __assign({ apolloClient: apolloClient }, { children: (0, jsx_runtime_1.jsx)(ProcessDefinitionListContextProvider_1.default, { children: (0, jsx_runtime_1.jsx)(FormsListContextProvider_1.default, { children: (0, jsx_runtime_1.jsx)(CustomDashboardListContextProvider_1.default, { children: (0, jsx_runtime_1.jsx)(CustomDashboardView_1.CustomDashboardViewContextProvider, { children: (0, jsx_runtime_1.jsx)(FormDetailsContextProvider_1.default, { children: (0, jsx_runtime_1.jsx)(ProcessFormContextProvider_1.default, { children: (0, jsx_runtime_1.jsx)(WorkflowFormContextProvider_1.default, { children: (0, jsx_runtime_1.jsx)(CloudEventFormContextProvider_1.default, { children: (0, jsx_runtime_1.jsx)(react_router_1.MemoryRouter, { children: (0, jsx_runtime_1.jsx)(react_router_dom_1.Switch, { children: (0, jsx_runtime_1.jsx)(react_router_dom_1.Route, { path: "/", render: renderPage }) }) }) }) }) }) }) }) }) }) }) })) })) })) }) })) })) })));
};
exports.default = DevUILayout;
//# sourceMappingURL=DevUILayout.js.map