"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkflowFormGatewayApiImpl = void 0;
var apis_1 = require("../apis");
var WorkflowFormGatewayApiImpl = (function () {
    function WorkflowFormGatewayApiImpl(baseUrl, openApiPath) {
        this.businessKey = '';
        this.baseUrl = baseUrl;
        this.openApiPath = openApiPath;
    }
    WorkflowFormGatewayApiImpl.prototype.setBusinessKey = function (bk) {
        this.businessKey = bk;
    };
    WorkflowFormGatewayApiImpl.prototype.getBusinessKey = function () {
        return this.businessKey;
    };
    WorkflowFormGatewayApiImpl.prototype.getCustomWorkflowSchema = function (workflowName) {
        return (0, apis_1.getCustomWorkflowSchema)(this.baseUrl, this.openApiPath, workflowName);
    };
    WorkflowFormGatewayApiImpl.prototype.startWorkflow = function (endpoint, data) {
        return (0, apis_1.startWorkflowRest)(data, endpoint, this.businessKey);
    };
    return WorkflowFormGatewayApiImpl;
}());
exports.WorkflowFormGatewayApiImpl = WorkflowFormGatewayApiImpl;
//# sourceMappingURL=WorkflowFormGatewayApi.js.map