"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TaskFormGatewayApiImpl = void 0;
var axios_1 = __importDefault(require("axios"));
var TaskFormGatewayApiImpl = (function () {
    function TaskFormGatewayApiImpl(getCurrentUser) {
        this.getCurrentUser = getCurrentUser;
    }
    TaskFormGatewayApiImpl.prototype.doSubmit = function (userTask, phase, payload) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            var endpoint = "".concat(userTask.endpoint, "?phase=").concat(phase, "&").concat(getTaskEndpointSecurityParams(_this.getCurrentUser()));
            axios_1.default
                .post(endpoint, payload, {
                headers: {
                    'Content-Type': 'application/json',
                    Accept: 'application/json'
                }
            })
                .then(function (response) {
                if (response.status == 200) {
                    resolve(response.data);
                }
                else {
                    reject(response);
                }
            })
                .catch(function (error) { return reject(error); });
        });
    };
    TaskFormGatewayApiImpl.prototype.getTaskFormSchema = function (userTask) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            var endpoint = getTaskSchemaEndPoint(userTask, _this.getCurrentUser());
            axios_1.default
                .get(endpoint, {
                headers: {
                    'Content-Type': 'application/json',
                    Accept: 'application/json'
                }
            })
                .then(function (responseObj) {
                if (responseObj.status == 200) {
                    resolve(responseObj.data);
                }
                else {
                    reject(responseObj);
                }
            })
                .catch(function (error) { return reject(error); });
        });
    };
    TaskFormGatewayApiImpl.prototype.getCustomForm = function (userTask) {
        return new Promise(function (resolve, reject) {
            var endpoint = getCustomFormEndpoint(userTask);
            axios_1.default
                .get(endpoint, {
                headers: {
                    'Content-Type': 'application/json',
                    Accept: 'application/json'
                }
            })
                .then(function (responseObj) {
                if (responseObj.status == 200) {
                    resolve(responseObj.data);
                }
                else {
                    reject(responseObj);
                }
            })
                .catch(function (err) { return reject(err); });
        });
    };
    return TaskFormGatewayApiImpl;
}());
exports.TaskFormGatewayApiImpl = TaskFormGatewayApiImpl;
function getTaskSchemaEndPoint(task, user) {
    var params = '';
    var endpoint = task.endpoint;
    if (task.completed) {
        endpoint = endpoint.slice(0, -(task.id.length + 1));
        endpoint = endpoint.replace(task.processInstanceId + '/', '');
    }
    else {
        params = "?".concat(getTaskEndpointSecurityParams(user));
    }
    return "".concat(endpoint, "/schema").concat(params);
}
function getTaskEndpointSecurityParams(user) {
    var groups = '';
    if (user.groups && user.groups.length > 0) {
        groups = "&group=".concat(user.groups.join('&group='));
    }
    return "user=".concat(user.id).concat(groups);
}
function getCustomFormEndpoint(task) {
    var suffix = "/".concat(task.processId, "/").concat(task.processInstanceId, "/").concat(task.name, "/").concat(task.id);
    var endPoint = task.endpoint.substring(0, task.endpoint.lastIndexOf(suffix));
    return "".concat(endPoint, "/forms/").concat(task.processId, "_").concat(task.name);
}
//# sourceMappingURL=TaskFormGatewayApi.js.map