import { Job, JobStatus, BulkCancel, JobCancel, JobsSortBy } from '@kogito-apps/management-console-shared/dist/types';
import { JobsManagementQueries } from './JobsManagementQueries';
export interface JobsManagementGatewayApi {
    jobsManagementState: any;
    initialLoad: (filter: JobStatus[], orderBy: JobsSortBy) => Promise<void>;
    applyFilter: (filter: JobStatus[]) => Promise<void>;
    bulkCancel: (jobsToBeActioned: Job[]) => Promise<BulkCancel>;
    cancelJob: (job: Pick<Job, 'id' | 'endpoint'>) => Promise<JobCancel>;
    rescheduleJob: (job: any, repeatInterval: number | string, repeatLimit: number | string, scheduleDate: Date) => Promise<{
        modalTitle: string;
        modalContent: string;
    }>;
    sortBy: (orderBy: JobsSortBy) => Promise<void>;
    query(offset: number, limit: number): Promise<Job[]>;
}
export interface JobsManagementState {
    filters: JobStatus[];
    orderBy: JobsSortBy | any;
}
export declare class JobsManagementGatewayApiImpl implements JobsManagementGatewayApi {
    private readonly queries;
    private _JobsManagementState;
    constructor(queries: JobsManagementQueries);
    get jobsManagementState(): JobsManagementState;
    initialLoad: (filter: JobStatus[], orderBy: JobsSortBy) => Promise<any>;
    applyFilter: (filter: JobStatus[]) => Promise<void>;
    cancelJob: (job: Pick<Job, 'id' | 'endpoint'>) => Promise<JobCancel>;
    rescheduleJob: (job: any, repeatInterval: number | string, repeatLimit: number | string, scheduleDate: Date) => Promise<{
        modalTitle: string;
        modalContent: string;
    }>;
    bulkCancel: (jobsToBeActioned: (Job & {
        errorMessage?: string;
    })[]) => Promise<BulkCancel>;
    sortBy: (orderBy: JobsSortBy) => Promise<void>;
    query(offset: number, limit: number): Promise<Job[]>;
}
