import { CustomDashboardFilter, CustomDashboardInfo } from '@kogito-apps/custom-dashboard-list';
export interface CustomDashboardListGatewayApi {
    getCustomDashboardFilter(): Promise<CustomDashboardFilter>;
    applyFilter(customDashboardFilter: CustomDashboardFilter): Promise<void>;
    getCustomDashboardsQuery(): Promise<CustomDashboardInfo[]>;
    openDashboard: (customDashboardInfo: CustomDashboardInfo) => Promise<void>;
    onOpenCustomDashboardListen: (listener: OnOpenDashboardListener) => UnSubscribeHandler;
}
export interface OnOpenDashboardListener {
    onOpen: (dashboardInfo: CustomDashboardInfo) => void;
}
export interface UnSubscribeHandler {
    unSubscribe: () => void;
}
export declare class CustomDashboardListGatewayApiImpl implements CustomDashboardListGatewayApi {
    private _CustomDashboardFilter;
    private readonly listeners;
    getCustomDashboardFilter: () => Promise<CustomDashboardFilter>;
    applyFilter: (customDashboardFilter: CustomDashboardFilter) => Promise<void>;
    getCustomDashboardsQuery(): Promise<CustomDashboardInfo[]>;
    openDashboard: (customDashboardInfo: CustomDashboardInfo) => Promise<void>;
    onOpenCustomDashboardListen(listener: OnOpenDashboardListener): UnSubscribeHandler;
}
