/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.dmn.rest;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.core.ast.ItemDefNodeImpl;
import org.kie.kogito.dmn.rest.DMNDecisionInfo;
import org.kie.kogito.dmn.rest.DMNDecisionServiceInfo;
import org.kie.kogito.dmn.rest.DMNInputDataInfo;
import org.kie.kogito.dmn.rest.DMNItemDefinitionInfo;

public class DMNModelInfo
implements Serializable {
    private String namespace;
    private String name;
    private String id;
    private Collection<DMNDecisionInfo> decisions = new HashSet<DMNDecisionInfo>();
    private Collection<DMNInputDataInfo> inputs = new HashSet<DMNInputDataInfo>();
    private Collection<DMNItemDefinitionInfo> itemDefinitions = new HashSet<DMNItemDefinitionInfo>();
    private Collection<DMNDecisionServiceInfo> decisionServices = new HashSet<DMNDecisionServiceInfo>();

    public static DMNModelInfo of(DMNModel model) {
        DMNModelInfo res = new DMNModelInfo();
        res.setNamespace(model.getNamespace());
        res.setName(model.getName());
        res.setId(model.getDefinitions().getId());
        res.setDecisions(model.getDecisions().stream().map(DMNDecisionInfo::of).collect(Collectors.toSet()));
        res.setDecisionServices(model.getDecisionServices().stream().map(DMNDecisionServiceInfo::of).collect(Collectors.toSet()));
        res.setInputs(model.getInputs().stream().map(DMNInputDataInfo::of).collect(Collectors.toSet()));
        res.setItemDefinitions(model.getItemDefinitions().stream().map(id -> DMNItemDefinitionInfo.of(((ItemDefNodeImpl)id).getItemDef())).collect(Collectors.toSet()));
        return res;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Collection<DMNDecisionInfo> getDecisions() {
        return this.decisions;
    }

    public void setDecisions(Collection<DMNDecisionInfo> decisions) {
        this.decisions = decisions;
    }

    public Collection<DMNInputDataInfo> getInputs() {
        return this.inputs;
    }

    public void setInputs(Collection<DMNInputDataInfo> inputs) {
        this.inputs = inputs;
    }

    public Collection<DMNItemDefinitionInfo> getItemDefinitions() {
        return this.itemDefinitions;
    }

    public void setItemDefinitions(Collection<DMNItemDefinitionInfo> itemDefinitions) {
        this.itemDefinitions = itemDefinitions;
    }

    public Collection<DMNDecisionServiceInfo> getDecisionServices() {
        return this.decisionServices;
    }

    public void setDecisionServices(Collection<DMNDecisionServiceInfo> decisionServices) {
        this.decisionServices = decisionServices;
    }
}

