/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.internal.utils;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConversionUtils {
    private static final Logger logger = LoggerFactory.getLogger(ConversionUtils.class);

    private ConversionUtils() {
    }

    public static <T> T convert(Object value, Class<T> clazz) {
        return ConversionUtils.convert(value, clazz, Object::toString);
    }

    public static <T> Collection<T> convertToCollection(Object value, Class<T> clazz) {
        return ConversionUtils.convertToCollection(value, clazz, ",");
    }

    public static <T> Collection<T> convertToCollection(Object value, Class<T> clazz, String separator) {
        if (value == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(value.toString().split(separator)).map(v -> ConversionUtils.convert(v, clazz)).collect(Collectors.toList());
    }

    public static <T> T convert(Object value, Class<T> clazz, Function<Object, String> stringConverter) {
        if (value == null || clazz.isAssignableFrom(value.getClass())) {
            return clazz.cast(value);
        }
        Method convert = ConversionUtils.getConvertMethod(clazz);
        if (convert != null) {
            try {
                return clazz.cast(convert.invoke(null, stringConverter.apply(value)));
            }
            catch (ReflectiveOperationException e) {
                logger.info("Execution of method {} failed. Trying different approach", (Object)convert.getName(), (Object)e);
            }
        }
        try {
            return clazz.getConstructor(String.class).newInstance(stringConverter.apply(value));
        }
        catch (ReflectiveOperationException e) {
            logger.info("Cannot use string constructor to perform conversion", (Throwable)e);
            throw new IllegalArgumentException(value + " cannot be converted to " + clazz.getName());
        }
    }

    private static Method getConvertMethod(Class<?> clazz) {
        try {
            return clazz.getMethod("valueOf", String.class);
        }
        catch (NoSuchMethodException ex) {
            for (Method method : clazz.getMethods()) {
                int modifiers = method.getModifiers();
                if (!Modifier.isStatic(modifiers) || method.getParameterCount() != 1 || !method.getParameterTypes()[0].equals(String.class) || !clazz.isAssignableFrom(method.getReturnType())) continue;
                return method;
            }
            return null;
        }
    }

    public static String toCamelCase(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        boolean convertNextCharToUpper = false;
        for (int i = 0; i < text.length(); ++i) {
            char currentChar = text.charAt(i);
            if (!Character.isLetterOrDigit(currentChar)) {
                convertNextCharToUpper = true;
                continue;
            }
            if (convertNextCharToUpper) {
                builder.append(Character.toUpperCase(currentChar));
                convertNextCharToUpper = false;
                continue;
            }
            builder.append(currentChar);
            convertNextCharToUpper = false;
        }
        if (builder.length() > 0) {
            builder.setCharAt(0, Character.toLowerCase(builder.charAt(0)));
        }
        return builder.toString();
    }

    public static String concatPaths(String onePath, String anotherPath) {
        return ConversionUtils.concatPaths(onePath, anotherPath, "/");
    }

    public static String concatPaths(String onePath, String anotherPath, String concatChars) {
        if (anotherPath.startsWith(concatChars)) {
            if (onePath.endsWith(concatChars)) {
                return onePath.concat(anotherPath.substring(concatChars.length()));
            }
            return onePath.concat(anotherPath);
        }
        if (onePath.endsWith(concatChars)) {
            return onePath.concat(anotherPath);
        }
        return onePath.concat(concatChars).concat(anotherPath);
    }

    public static boolean isEmpty(String value) {
        return Objects.isNull(value) || value.isBlank();
    }

    public static boolean isNotEmpty(String value) {
        return !ConversionUtils.isEmpty(value);
    }

    public static String sanitizeClassName(String className) {
        return ConversionUtils.sanitizeJavaName(className, true);
    }

    public static String sanitizeJavaName(String name) {
        return ConversionUtils.sanitizeJavaName(name, false);
    }

    public static String sanitizeJavaName(String name, boolean capitalize) {
        if (ConversionUtils.isEmpty(name)) {
            return name;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(capitalize ? Character.toUpperCase(name.charAt(0)) : name.charAt(0));
        for (int i = 1; i < name.length(); ++i) {
            char c = name.charAt(i);
            sb.append(Character.isJavaIdentifierPart(c) ? Character.valueOf(c) : "_");
        }
        return sb.toString();
    }
}

