/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.cloudevents.spring;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.CompletionStage;
import org.kie.kogito.config.ConfigBean;
import org.kie.kogito.event.CloudEventMarshaller;
import org.kie.kogito.event.DataEvent;
import org.kie.kogito.event.EventEmitter;
import org.kie.kogito.event.EventMarshaller;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Component;

@Component
public class SpringKafkaCloudEventEmitter<M>
implements EventEmitter {
    @Autowired
    KafkaTemplate<String, M> emitter;
    @Value(value="${kogito.addon.cloudevents.kafka.kogito_outgoing_stream:kogito_outgoing_stream}")
    String defaultTopicName;
    @Autowired
    Environment env;
    @Autowired
    EventMarshaller<M> marshaller;
    @Autowired
    CloudEventMarshaller<M> ceMarshaller;
    @Autowired
    ConfigBean configBean;
    @Autowired
    ObjectMapper mapper;

    public CompletionStage<Void> emit(DataEvent<?> event) {
        try {
            return this.emitter.send(this.env.getProperty("kogito.addon.cloudevents.kafka.kogito_outgoing_stream." + event.getType(), this.defaultTopicName), this.configBean.useCloudEvents() ? this.ceMarshaller.marshall(event.asCloudEvent(this.ceMarshaller.cloudEventDataFactory())) : this.marshaller.marshall(event.getData())).completable().thenApply(r -> null);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

