/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.decision.quarkus.deployment;

import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.ContainerNetwork;
import com.github.dockerjava.api.model.ContainerNetworkSettings;
import com.github.dockerjava.api.model.ContainerPort;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.IsDockerWorking;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.runtime.LaunchMode;
import java.io.Closeable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.kie.kogito.quarkus.extensions.spi.deployment.TrustyServiceAvailableBuildItem;
import org.kie.kogito.tracing.decision.quarkus.deployment.DevServicesConfig;
import org.kie.kogito.tracing.decision.quarkus.deployment.KogitoBuildTimeConfig;
import org.kie.kogito.tracing.decision.quarkus.deployment.KogitoDevServicesBuildTimeConfig;
import org.kie.kogito.tracing.decision.quarkus.devservices.TrustyServiceInMemoryContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.utility.DockerImageName;

public class KogitoDevServicesProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(KogitoDevServicesProcessor.class);
    private static final ContainerLocator LOCATOR = new ContainerLocator("kogito-dev-service-trusty-service", 8080);
    static volatile Closeable closeable;
    static volatile TrustyServiceDevServiceConfig cfg;
    static volatile boolean first;
    private final IsDockerWorking isDockerWorking = new IsDockerWorking(true);

    @BuildStep(onlyIf={GlobalDevServicesConfig.Enabled.class, IsDevelopment.class})
    public void startTrustyServiceDevService(DevServicesConfig devServicesConfig, BuildProducer<SystemPropertyBuildItem> systemProperties, BuildProducer<TrustyServiceAvailableBuildItem> trustyServiceAvailableBuildItemBuildProducer, LaunchModeBuildItem launchMode, KogitoBuildTimeConfig buildTimeConfig, List<DevServicesSharedNetworkBuildItem> devServicesSharedNetwork, Optional<ConsoleInstalledBuildItem> consoleInstalled, CuratedApplicationShutdownBuildItem applicationShutdown, LoggingSetupBuildItem loggingSetup) {
        LOGGER.info("Docker Containers configuration...");
        ((List)DockerClientFactory.lazyClient().listContainersCmd().exec()).forEach(c -> {
            LOGGER.debug("----> Image: " + c.getImage());
            if (Objects.nonNull(c.getNames())) {
                Arrays.stream(c.getNames()).forEach(n -> LOGGER.debug(String.format("----> Name: %s", n)));
            }
            if (Objects.nonNull(c.getLabels())) {
                c.getLabels().forEach((key, value) -> LOGGER.debug(String.format("----> Label: [%s]=[%s]", key, value)));
            }
            LOGGER.debug("----> Ports: " + Arrays.stream(c.getPorts()).map(p -> p.getPrivatePort() + ">>" + p.getPublicPort()).collect(Collectors.joining(", ")));
            LOGGER.debug("----> Network: " + (Objects.isNull(c.getNetworkSettings()) ? "" : c.getNetworkSettings().getNetworks().entrySet().stream().map(n -> String.format("%s=%s [%s]", n.getKey(), n.getValue(), ((ContainerNetwork)n.getValue()).getIpAddress())).collect(Collectors.joining(", "))));
        });
        TrustyServiceDevServiceConfig configuration = this.getConfiguration(buildTimeConfig);
        if (closeable != null) {
            boolean shouldShutdown;
            boolean bl = shouldShutdown = !configuration.equals(cfg);
            if (!shouldShutdown) {
                trustyServiceAvailableBuildItemBuildProducer.produce((BuildItem)new TrustyServiceAvailableBuildItem());
                return;
            }
            this.shutdownTrustyService();
            cfg = null;
        }
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "Kogito TrustyService DevService starting:", consoleInstalled, loggingSetup);
        TrustyServiceInstance trustyService = null;
        try {
            trustyService = this.startTrustyService(configuration, devServicesConfig, launchMode, !devServicesSharedNetwork.isEmpty());
            if (trustyService != null) {
                trustyServiceAvailableBuildItemBuildProducer.produce((BuildItem)new TrustyServiceAvailableBuildItem());
                closeable = trustyService.getCloseable();
            }
            compressor.close();
        }
        catch (Exception t) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException("Failed to start Kogito TrustyService DevServices", t);
        }
        LOGGER.info("Discovering TrustyService instance...");
        ((List)DockerClientFactory.lazyClient().listContainersCmd().exec()).stream().filter(container -> this.isTrustyServiceImage((Container)container, configuration)).findFirst().ifPresent(container -> {
            Optional<Object> port = Optional.empty();
            Optional<Object> ipAddress = Optional.empty();
            ContainerPort[] containerPorts = container.getPorts();
            ContainerNetworkSettings networkSettings = container.getNetworkSettings();
            if (Objects.nonNull(containerPorts)) {
                port = Arrays.stream(containerPorts).map(ContainerPort::getPrivatePort).filter(Objects::nonNull).findFirst();
            }
            if (Objects.nonNull(networkSettings)) {
                ipAddress = networkSettings.getNetworks().values().stream().map(ContainerNetwork::getIpAddress).filter(Objects::nonNull).findFirst();
            }
            LOGGER.debug(String.format("[TrustyService] Private Port: %s", port.orElse(0)));
            LOGGER.debug(String.format("[TrustyService] IP Address: %s", ipAddress.orElse("<None>")));
            if (ipAddress.isPresent() && port.isPresent()) {
                String trustyServiceServer = String.format("http://%s:%s", ipAddress.get(), port.get());
                LOGGER.debug(String.format("Setting System Property '%s' to '%s'", "kogito.trusty.http.url", trustyServiceServer));
                systemProperties.produce((BuildItem)new SystemPropertyBuildItem("kogito.trusty.http.url", trustyServiceServer));
            }
        });
        if (first) {
            first = false;
            Runnable closeTask = () -> {
                if (closeable != null) {
                    this.shutdownTrustyService();
                }
                first = true;
                closeable = null;
                cfg = null;
            };
            applicationShutdown.addCloseTask(closeTask, true);
        }
        cfg = configuration;
        if (trustyService != null && trustyService.isOwner()) {
            LOGGER.info("DevServices for Kogito TrustyService started at {}", (Object)trustyService.getUrl());
        }
    }

    private boolean isTrustyServiceImage(Container container, TrustyServiceDevServiceConfig trustyServiceDevServiceConfig) {
        String name = container.getImage();
        return Objects.equals(trustyServiceDevServiceConfig.imageName, name);
    }

    private void shutdownTrustyService() {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                LOGGER.error("Failed to stop Kogito Data Index", (Throwable)e);
            }
            finally {
                closeable = null;
            }
        }
    }

    private TrustyServiceInstance startTrustyService(TrustyServiceDevServiceConfig config, DevServicesConfig devServicesConfig, LaunchModeBuildItem launchMode, boolean useSharedNetwork) {
        if (!config.devServicesEnabled) {
            LOGGER.info("Not starting DevServices for Kogito, as it has been disabled in the config.");
            return null;
        }
        if (!this.isDockerWorking.getAsBoolean()) {
            LOGGER.warn("Docker isn't working, unable to start TrustyService image.");
            return null;
        }
        Optional maybeContainerAddress = LOCATOR.locateContainer(config.serviceName, config.shared, launchMode.getLaunchMode());
        Supplier<TrustyServiceInstance> trustyServiceSupplier = () -> {
            try {
                TrustyServiceInMemoryContainer container = new TrustyServiceInMemoryContainer(DockerImageName.parse((String)config.imageName), config.fixedExposedPort, launchMode.getLaunchMode() == LaunchMode.DEVELOPMENT ? config.serviceName : null, useSharedNetwork, config.portUsedByTest);
                LOGGER.debug(String.format("TrustyService DataSource Kind: %s", devServicesConfig.getDataSourceKind()));
                LOGGER.debug(String.format("TrustyService DataSource Username: %s", devServicesConfig.getDataSourceUserName()));
                LOGGER.debug(String.format("TrustyService DataSource Password: %s", devServicesConfig.getDataSourcePassword()));
                LOGGER.debug(String.format("TrustyService DataSource URL: %s", devServicesConfig.getDataSourceUrl()));
                LOGGER.debug(String.format("TrustyService Kafka Bootstrap Server: %s", devServicesConfig.getKafkaBootstrapServer()));
                LOGGER.debug(String.format("TrustyService Hibernate ORM Database Generation: %s", devServicesConfig.getHibernateOrmDatabaseGeneration()));
                container.addEnv("SCRIPT_DEBUG", "false");
                container.addEnv("EXPLAINABILITY_ENABLED", "false");
                container.addEnv(DevServicesConfig.Property.QuarkusDataSourceDbKind.getEnvironmentVariableName(), devServicesConfig.getDataSourceKind());
                container.addEnv(DevServicesConfig.Property.QuarkusDataSourceUserName.getEnvironmentVariableName(), devServicesConfig.getDataSourceUserName());
                container.addEnv(DevServicesConfig.Property.QuarkusDataSourcePassword.getEnvironmentVariableName(), devServicesConfig.getDataSourcePassword());
                container.addEnv(DevServicesConfig.Property.QuarkusDataSourceJdbcUrl.getEnvironmentVariableName(), devServicesConfig.getDataSourceUrl());
                container.addEnv(DevServicesConfig.Property.KafkaBootstrapServers.getEnvironmentVariableName(), devServicesConfig.getKafkaBootstrapServer());
                container.addEnv(DevServicesConfig.Property.HibernateOrmDatabaseGeneration.getEnvironmentVariableName(), devServicesConfig.getHibernateOrmDatabaseGeneration());
                container.start();
                return new TrustyServiceInstance(container.getUrl(), () -> ((TrustyServiceInMemoryContainer)container).close());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        };
        return maybeContainerAddress.map(containerAddress -> new TrustyServiceInstance(containerAddress.getUrl(), null)).orElseGet(trustyServiceSupplier);
    }

    private TrustyServiceDevServiceConfig getConfiguration(KogitoBuildTimeConfig cfg) {
        KogitoDevServicesBuildTimeConfig devServicesConfig = cfg.devServicesTrusty;
        return new TrustyServiceDevServiceConfig(devServicesConfig);
    }

    static {
        first = true;
    }

    private static final class TrustyServiceDevServiceConfig {
        private final boolean devServicesEnabled;
        private final String imageName;
        private final Integer fixedExposedPort;
        private final boolean shared;
        private final String serviceName;
        private final int portUsedByTest;

        public TrustyServiceDevServiceConfig(KogitoDevServicesBuildTimeConfig config) {
            this.devServicesEnabled = config.enabled.orElse(true);
            this.imageName = config.imageName;
            this.fixedExposedPort = config.port.orElse(0);
            this.shared = config.shared;
            this.serviceName = config.serviceName;
            this.portUsedByTest = config.portUsedByTest;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TrustyServiceDevServiceConfig that = (TrustyServiceDevServiceConfig)o;
            return this.devServicesEnabled == that.devServicesEnabled && Objects.equals(this.imageName, that.imageName) && Objects.equals(this.fixedExposedPort, that.fixedExposedPort);
        }

        public int hashCode() {
            return Objects.hash(this.devServicesEnabled, this.imageName, this.fixedExposedPort);
        }
    }

    private static class TrustyServiceInstance {
        private final String url;
        private final Closeable closeable;

        public TrustyServiceInstance(String url, Closeable closeable) {
            this.url = url;
            this.closeable = closeable;
        }

        public boolean isOwner() {
            return this.closeable != null;
        }

        public String getUrl() {
            return this.url;
        }

        public Closeable getCloseable() {
            return this.closeable;
        }
    }
}

