/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.decision.quarkus.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.DevServicesConfigResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.runtime.configuration.ConfigUtils;
import org.kie.kogito.tracing.decision.quarkus.deployment.DevServicesConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevServicesSetupEnvironmentProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DevServicesSetupEnvironmentProcessor.class);
    private static final String HIBERNATE_ORM_DATABASE_GENERATION_STRATEGY = "drop-and-create";

    @BuildStep(onlyIf={IsDevelopment.class})
    public void extractDevServicesDefaultDataSourceConfiguration(BuildProducer<DevServicesConfigResultBuildItem> devServicesConfigResultBuilder, BuildProducer<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItemBuildProducer) {
        LOGGER.debug("Checking DevService configuration...");
        if (!ConfigUtils.isPropertyPresent((String)DevServicesConfig.Property.HibernateOrmDatabaseGeneration.getPropertyName())) {
            LOGGER.debug(String.format("Setting %s=%s to initialize DevServices managed database", DevServicesConfig.Property.HibernateOrmDatabaseGeneration.getPropertyName(), HIBERNATE_ORM_DATABASE_GENERATION_STRATEGY));
            devServicesConfigResultBuilder.produce((BuildItem)new DevServicesConfigResultBuildItem(DevServicesConfig.Property.HibernateOrmDatabaseGeneration.getPropertyName(), HIBERNATE_ORM_DATABASE_GENERATION_STRATEGY));
        }
        LOGGER.debug("Enabling use of TestContainers 'Shared Network' for all containers started by Quarkus.");
        devServicesSharedNetworkBuildItemBuildProducer.produce((BuildItem)new DevServicesSharedNetworkBuildItem());
    }
}

