/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.decision.quarkus.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.DevServicesLauncherConfigResultBuildItem;
import java.util.Map;
import org.kie.kogito.tracing.decision.quarkus.deployment.DevServicesConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevServicesConfigProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DevServicesConfigProcessor.class);

    @BuildStep(onlyIf={IsDevelopment.class})
    public void extractDevServicesDefaultDataSourceConfiguration(DevServicesLauncherConfigResultBuildItem configurationItems, BuildProducer<DevServicesConfig> devServicesPostgreSQLConfigBuilder) {
        DevServicesConfig devServicesConfig = new DevServicesConfig();
        LOGGER.debug("Extracting Quarkus DevService configurations...");
        Map quarkusConfig = configurationItems.getConfig();
        devServicesConfig.setDataSourceKind((String)quarkusConfig.get(DevServicesConfig.Property.QuarkusDataSourceDbKind.getPropertyName()));
        devServicesConfig.setDataSourceUserName((String)quarkusConfig.get(DevServicesConfig.Property.QuarkusDataSourceUserName.getPropertyName()));
        devServicesConfig.setDataSourcePassword((String)quarkusConfig.get(DevServicesConfig.Property.QuarkusDataSourcePassword.getPropertyName()));
        devServicesConfig.setDataSourceUrl((String)quarkusConfig.get(DevServicesConfig.Property.QuarkusDataSourceJdbcUrl.getPropertyName()));
        devServicesConfig.setKafkaBootstrapServer((String)quarkusConfig.get(DevServicesConfig.Property.KafkaBootstrapServers.getPropertyName()));
        devServicesConfig.setHibernateOrmDatabaseGeneration((String)quarkusConfig.get(DevServicesConfig.Property.HibernateOrmDatabaseGeneration.getPropertyName()));
        LOGGER.debug(String.format("DevServices default DataSource Kind: %s", devServicesConfig.getDataSourceKind()));
        LOGGER.debug(String.format("DevServices default DataSource Username: %s", devServicesConfig.getDataSourceUserName()));
        LOGGER.debug(String.format("DevServices default DataSource Password: %s", devServicesConfig.getDataSourcePassword()));
        LOGGER.debug(String.format("DevServices default DataSource URL: %s", devServicesConfig.getDataSourceUrl()));
        LOGGER.debug(String.format("DevServices Kafka Bootstrap Server: %s", devServicesConfig.getKafkaBootstrapServer()));
        LOGGER.debug(String.format("DevServices Hibernate ORM Database Generation: %s", devServicesConfig.getHibernateOrmDatabaseGeneration()));
        devServicesPostgreSQLConfigBuilder.produce((BuildItem)devServicesConfig);
    }
}

