/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.knative.serving.deployment.customfunctions;

import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.functions.FunctionDefinition;
import io.serverlessworkflow.api.functions.FunctionRef;
import io.vertx.core.http.HttpMethod;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.jbpm.ruleflow.core.RuleFlowNodeContainerFactory;
import org.jbpm.ruleflow.core.factory.NodeFactory;
import org.jbpm.ruleflow.core.factory.WorkItemNodeFactory;
import org.kie.kogito.addons.quarkus.knative.serving.customfunctions.CloudEventKnativeParamsDecorator;
import org.kie.kogito.addons.quarkus.knative.serving.customfunctions.Operation;
import org.kie.kogito.addons.quarkus.knative.serving.customfunctions.PlainJsonKnativeParamsDecorator;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.serverless.workflow.parser.FunctionTypeHandlerFactory;
import org.kie.kogito.serverless.workflow.parser.ParserContext;
import org.kie.kogito.serverless.workflow.parser.VariableInfo;
import org.kie.kogito.serverless.workflow.parser.types.WorkItemTypeHandler;
import org.kie.kogito.serverless.workflow.suppliers.CollectionParamsDecoratorSupplier;
import org.kie.kogito.serverless.workflow.suppliers.ParamsRestBodyBuilderSupplier;
import org.kie.kogito.serverless.workflow.utils.ServerlessWorkflowUtils;

public class KnativeTypeHandler
extends WorkItemTypeHandler {
    private static final String DEFAULT_REQUEST_TIMEOUT_VALUE = "10000";

    public NodeFactory<?, ?> getActionNode(Workflow workflow, ParserContext context, RuleFlowNodeContainerFactory<?, ?> embeddedSubProcess, FunctionDefinition functionDef, FunctionRef functionRef, VariableInfo varInfo) {
        this.validateArgs(functionRef);
        WorkItemNodeFactory node = (WorkItemNodeFactory)this.buildWorkItem(embeddedSubProcess, context, varInfo.getInputVar(), varInfo.getOutputVar()).name(functionDef.getName());
        List<String> payloadFields = KnativeTypeHandler.getPayloadFields(functionRef);
        Operation operation = Operation.parse((String)FunctionTypeHandlerFactory.trimCustomOperation((FunctionDefinition)functionDef));
        if (HttpMethod.GET.equals((Object)operation.getHttpMethod())) {
            node.workParameter("ParamsDecorator", (Object)new CollectionParamsDecoratorSupplier(List.of(), payloadFields));
        } else {
            if (!payloadFields.isEmpty()) {
                node.workParameter("knative_function_payload_fields", payloadFields);
            }
            if (operation.isCloudEvent()) {
                node.workParameter("ParamsDecorator", (Object)CloudEventKnativeParamsDecorator.class.getName());
            } else {
                node.workParameter("ParamsDecorator", (Object)PlainJsonKnativeParamsDecorator.class.getName());
            }
        }
        ((WorkItemNodeFactory)((WorkItemNodeFactory)node.workParameter("knative_function_service", (Object)operation.getService())).workParameter("knative_function_path", (Object)operation.getPath())).workParameter("Method", (Object)operation.getHttpMethod());
        return this.addFunctionArgs(workflow, this.fillWorkItemHandler(workflow, context, node, functionDef), functionRef);
    }

    private static List<String> getPayloadFields(FunctionRef functionRef) {
        ArrayList<String> payloadFields = new ArrayList<String>();
        if (functionRef.getArguments() != null && !functionRef.getArguments().isEmpty()) {
            functionRef.getArguments().fieldNames().forEachRemaining(payloadFields::add);
        }
        return payloadFields;
    }

    protected <T extends RuleFlowNodeContainerFactory<T, ?>> WorkItemNodeFactory<T> fillWorkItemHandler(Workflow workflow, ParserContext context, WorkItemNodeFactory<T> node, FunctionDefinition functionDef) {
        if (functionDef.getMetadata() != null) {
            functionDef.getMetadata().forEach((arg_0, arg_1) -> node.metaData(arg_0, arg_1));
        }
        Supplier requestTimeout = ServerlessWorkflowUtils.runtimeRestApi((FunctionDefinition)functionDef, (String)"timeout", (KogitoBuildContext)context.getContext(), String.class, (Object)DEFAULT_REQUEST_TIMEOUT_VALUE);
        return (WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)node.workParameter("BodyBuilder", (Object)new ParamsRestBodyBuilderSupplier())).workParameter("RequestTimeout", (Object)requestTimeout)).metaData("Type", (Object)"Rest")).workName("knative");
    }

    public String type() {
        return "knative";
    }
}

