/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.test.quarkus.kafka;

import java.util.HashMap;
import java.util.Map;
import org.kie.kogito.index.test.containers.DataIndexPostgreSqlContainer;
import org.kie.kogito.index.test.containers.KogitoKafkaContainerWithoutBridge;
import org.kie.kogito.test.resources.TestResource;
import org.kie.kogito.testcontainers.KogitoPostgreSqlContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class DataIndexPostgreSqlKafkaResource
implements TestResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataIndexPostgreSqlKafkaResource.class);
    private KogitoKafkaContainerWithoutBridge kafka = new KogitoKafkaContainerWithoutBridge();
    private KogitoPostgreSqlContainer postgresql = new KogitoPostgreSqlContainer();
    private DataIndexPostgreSqlContainer dataIndex = new DataIndexPostgreSqlContainer();
    private Map<String, String> properties = new HashMap<String, String>();

    public String getResourceName() {
        return this.dataIndex.getResourceName();
    }

    public void start() {
        LOGGER.debug("Starting PostgreSQL Quarkus test resource");
        this.properties.clear();
        Network network = Network.newNetwork();
        this.postgresql.withNetwork(network);
        this.postgresql.withNetworkAliases(new String[]{"postgresql"});
        this.postgresql.waitingFor((WaitStrategy)Wait.forListeningPort());
        this.postgresql.start();
        this.kafka.withNetwork(network);
        this.kafka.withNetworkAliases(new String[]{"kafka"});
        this.kafka.waitingFor((WaitStrategy)Wait.forListeningPort());
        this.kafka.start();
        String kafkaURL = this.kafka.getBootstrapServers();
        this.properties.put("kafka.bootstrap.servers", kafkaURL);
        this.properties.put("spring.kafka.bootstrap-servers", kafkaURL);
        this.dataIndex.addProtoFileFolder();
        this.dataIndex.withNetwork(network);
        this.dataIndex.setPostgreSqlURL("jdbc:postgresql://postgresql:5432/" + this.postgresql.getDatabaseName(), this.postgresql.getUsername(), this.postgresql.getPassword());
        this.dataIndex.setKafkaURL("kafka:29092");
        this.dataIndex.addEnv("QUARKUS_PROFILE", "kafka-events-support");
        this.dataIndex.start();
        LOGGER.debug("PostgreSQL Quarkus test resource started");
    }

    public void stop() {
        this.dataIndex.stop();
        this.postgresql.stop();
        this.kafka.stop();
        LOGGER.debug("PostgreSQL Quarkus test resource stopped");
    }

    public int getMappedPort() {
        return this.dataIndex.getMappedPort();
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public DataIndexPostgreSqlContainer getDataIndex() {
        return this.dataIndex;
    }
}

