/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.test.quarkus.kafka;

import java.util.HashMap;
import java.util.Map;
import org.kie.kogito.index.test.containers.DataIndexOracleContainer;
import org.kie.kogito.index.test.containers.KogitoKafkaContainerWithoutBridge;
import org.kie.kogito.test.resources.TestResource;
import org.kie.kogito.testcontainers.KogitoOracleSqlContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class DataIndexOracleKafkaResource
implements TestResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataIndexOracleKafkaResource.class);
    KogitoKafkaContainerWithoutBridge kafka = new KogitoKafkaContainerWithoutBridge();
    KogitoOracleSqlContainer oracle = new KogitoOracleSqlContainer();
    DataIndexOracleContainer dataIndex = new DataIndexOracleContainer();
    Map<String, String> properties = new HashMap<String, String>();

    public String getResourceName() {
        return this.dataIndex.getResourceName();
    }

    public void start() {
        LOGGER.debug("Starting Oracle Quarkus test resource");
        this.properties.clear();
        Network network = Network.newNetwork();
        this.oracle.withNetwork(network);
        this.oracle.withNetworkAliases(new String[]{"oracle"});
        this.oracle.withUsername("kogito");
        this.oracle.withPassword("kogito");
        this.oracle.start();
        this.kafka.withNetwork(network);
        this.kafka.withNetworkAliases(new String[]{"kafka"});
        this.kafka.waitingFor((WaitStrategy)Wait.forListeningPort());
        this.kafka.start();
        String kafkaURL = this.kafka.getBootstrapServers();
        this.properties.put("kafka.bootstrap.servers", kafkaURL);
        this.properties.put("spring.kafka.bootstrap-servers", kafkaURL);
        this.dataIndex.addProtoFileFolder();
        this.dataIndex.withNetwork(network);
        this.dataIndex.setDatabaseURL("jdbc:oracle:thin:@oracle:1521/" + this.oracle.getDatabaseName(), this.oracle.getUsername(), this.oracle.getPassword());
        this.dataIndex.setKafkaURL("kafka:29092");
        this.dataIndex.addEnv("QUARKUS_PROFILE", "kafka-events-support");
        this.dataIndex.start();
        LOGGER.debug("Oracle Quarkus test resource started");
    }

    public void stop() {
        this.dataIndex.stop();
        this.oracle.stop();
        this.kafka.stop();
        LOGGER.debug("Oracle Quarkus test resource stopped");
    }

    public int getMappedPort() {
        return this.dataIndex.getMappedPort();
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }
}

