/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.test.quarkus.kafka;

import java.util.HashMap;
import java.util.Map;
import org.kie.kogito.index.test.containers.DataIndexMongoDBContainer;
import org.kie.kogito.index.test.containers.KogitoKafkaContainerWithoutBridge;
import org.kie.kogito.test.resources.TestResource;
import org.kie.kogito.testcontainers.KogitoMongoDBContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Network;

public class DataIndexMongoDBKafkaResource
implements TestResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataIndexMongoDBKafkaResource.class);
    KogitoKafkaContainerWithoutBridge kafka = new KogitoKafkaContainerWithoutBridge();
    KogitoMongoDBContainer mongodb = new KogitoMongoDBContainer();
    DataIndexMongoDBContainer dataIndex = new DataIndexMongoDBContainer();
    Map<String, String> properties = new HashMap<String, String>();

    public String getResourceName() {
        return this.dataIndex.getResourceName();
    }

    public void start() {
        LOGGER.debug("Start MongoDB Quarkus test resource");
        this.properties.clear();
        Network network = Network.newNetwork();
        this.mongodb.withNetwork(network);
        this.mongodb.withNetworkAliases(new String[]{"mongo"});
        this.mongodb.start();
        this.properties.put("quarkus.mongodb.connection-string", this.mongodb.getReplicaSetUrl());
        this.kafka.withNetwork(network);
        this.kafka.withNetworkAliases(new String[]{"kafka"});
        this.kafka.start();
        String kafkaURL = this.kafka.getBootstrapServers();
        this.properties.put("kafka.bootstrap.servers", kafkaURL);
        this.properties.put("spring.kafka.bootstrap-servers", kafkaURL);
        this.dataIndex.addProtoFileFolder();
        this.dataIndex.withNetwork(network);
        this.dataIndex.setMongoDBURL("mongodb://mongo:27017/test");
        this.dataIndex.setKafkaURL("kafka:29092");
        this.dataIndex.addEnv("QUARKUS_PROFILE", "kafka-events-support");
        this.dataIndex.start();
        LOGGER.debug("Data Index Service started");
    }

    public void stop() {
        this.dataIndex.stop();
        this.mongodb.stop();
        this.kafka.stop();
        LOGGER.debug("Stop MongoDB Quarkus test resource");
    }

    public int getMappedPort() {
        return this.dataIndex.getMappedPort();
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }
}

