/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.test.quarkus.http;

import org.kie.kogito.index.test.containers.DataIndexPostgreSqlContainer;
import org.kie.kogito.test.resources.TestResource;
import org.kie.kogito.testcontainers.KogitoPostgreSqlContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class DataIndexPostgreSqlHttpResource
implements TestResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataIndexPostgreSqlHttpResource.class);
    private KogitoPostgreSqlContainer postgresql = new KogitoPostgreSqlContainer();
    private DataIndexPostgreSqlContainer dataIndex = new DataIndexPostgreSqlContainer();

    public String getResourceName() {
        return this.dataIndex.getResourceName();
    }

    public void start() {
        LOGGER.debug("Starting PostgreSQL Quarkus test resource");
        Network network = Network.newNetwork();
        this.postgresql.withNetwork(network);
        this.postgresql.withNetworkAliases(new String[]{"postgresql"});
        this.postgresql.waitingFor((WaitStrategy)Wait.forListeningPort());
        this.postgresql.start();
        this.dataIndex.addProtoFileFolder();
        this.dataIndex.withNetwork(network);
        this.dataIndex.setPostgreSqlURL("jdbc:postgresql://postgresql:5432/" + this.postgresql.getDatabaseName(), this.postgresql.getUsername(), this.postgresql.getPassword());
        this.dataIndex.addEnv("QUARKUS_PROFILE", "http-events-support");
        this.dataIndex.start();
        LOGGER.debug("PostgreSQL Quarkus test resource started");
    }

    public void stop() {
        this.dataIndex.stop();
        this.postgresql.stop();
        LOGGER.debug("PostgreSQL Quarkus test resource stopped");
    }

    public int getMappedPort() {
        return this.dataIndex.getMappedPort();
    }

    public KogitoPostgreSqlContainer getPostgresql() {
        return this.postgresql;
    }

    public DataIndexPostgreSqlContainer getDataIndex() {
        return this.dataIndex;
    }
}

