/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.test.quarkus.http;

import java.util.HashMap;
import java.util.Map;
import org.kie.kogito.index.test.containers.DataIndexInfinispanContainer;
import org.kie.kogito.test.resources.TestResource;
import org.kie.kogito.testcontainers.KogitoInfinispanContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Network;

public class DataIndexInfinispanHttpResource
implements TestResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataIndexInfinispanHttpResource.class);
    KogitoInfinispanContainer infinispan = new KogitoInfinispanContainer();
    DataIndexInfinispanContainer dataIndex = new DataIndexInfinispanContainer();
    Map<String, String> properties = new HashMap<String, String>();

    public String getResourceName() {
        return this.dataIndex.getResourceName();
    }

    public void start() {
        LOGGER.debug("Start Infinispan Quarkus test resource");
        this.properties.clear();
        Network network = Network.newNetwork();
        this.infinispan.withNetwork(network);
        this.infinispan.withNetworkAliases(new String[]{"infinispan"});
        this.infinispan.start();
        String infinispanURL = "localhost:" + this.infinispan.getMappedPort();
        this.properties.put("quarkus.infinispan-client.hosts", infinispanURL);
        this.dataIndex.addProtoFileFolder();
        this.dataIndex.withNetwork(network);
        this.dataIndex.setInfinispanURL("infinispan:11222");
        this.dataIndex.addEnv("QUARKUS_PROFILE", "http-events-support");
        this.dataIndex.start();
        LOGGER.debug("Data Index Service started");
    }

    public void stop() {
        this.dataIndex.stop();
        this.infinispan.stop();
        LOGGER.debug("Stop Infinispan Quarkus test resource");
    }

    public int getMappedPort() {
        return this.dataIndex.getMappedPort();
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }
}

