/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.test.quarkus;

import java.util.HashMap;
import java.util.Map;
import org.kie.kogito.index.test.containers.DataIndexInMemoryContainer;
import org.kie.kogito.test.resources.TestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Network;

public class DataIndexInMemoryResource
implements TestResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataIndexInMemoryResource.class);
    DataIndexInMemoryContainer dataIndex = new DataIndexInMemoryContainer();
    Map<String, String> properties = new HashMap<String, String>();

    public String getResourceName() {
        return this.dataIndex.getResourceName();
    }

    public void start() {
        LOGGER.debug("Starting InMemory Quarkus test resource");
        this.properties.clear();
        Network network = Network.newNetwork();
        this.dataIndex.addProtoFileFolder();
        this.dataIndex.withNetwork(network);
        this.dataIndex.start();
        LOGGER.debug("InMemory Quarkus test resource started");
    }

    public void stop() {
        this.dataIndex.stop();
        LOGGER.debug("InMemory Quarkus test resource stopped");
    }

    public int getMappedPort() {
        return this.dataIndex.getMappedPort();
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }
}

