/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.test.containers;

import java.io.File;
import org.kie.kogito.test.resources.TestResource;
import org.kie.kogito.testcontainers.KogitoGenericContainer;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public abstract class AbstractDataIndexContainer
extends KogitoGenericContainer<AbstractDataIndexContainer>
implements TestResource {
    public static final int PORT = 8080;

    public AbstractDataIndexContainer(String containerName) {
        super(containerName);
        this.addExposedPort(8080);
        this.waitingFor((WaitStrategy)Wait.forListeningPort());
        this.addEnv("KOGITO_PROTOBUF_FOLDER", "/home/kogito/data/protobufs/");
        this.withAccessToHost(true);
    }

    public void setKafkaURL(String kafkaURL) {
        this.addEnv("KAFKA_BOOTSTRAP_SERVERS", kafkaURL);
    }

    public void addProtoFileFolder() {
        String pathStr = "target/classes/META-INF/resources/persistence/protobuf/";
        String absolutePath = new File(pathStr).getAbsolutePath();
        this.withFileSystemBind(absolutePath, "/home/kogito/data/protobufs/", BindMode.READ_ONLY);
    }

    public int getMappedPort() {
        return this.getMappedPort(8080);
    }
}

