/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.mongodb.model;

import com.fasterxml.jackson.databind.JsonNode;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bson.Document;
import org.kie.kogito.index.model.Attachment;
import org.kie.kogito.index.model.Comment;
import org.kie.kogito.index.model.UserTaskInstance;
import org.kie.kogito.index.mongodb.model.UserTaskInstanceEntity;
import org.kie.kogito.persistence.mongodb.model.ModelUtils;
import org.kie.kogito.persistence.mongodb.model.MongoEntityMapper;

public class UserTaskInstanceEntityMapper
implements MongoEntityMapper<UserTaskInstance, UserTaskInstanceEntity> {
    static final String COMMENTS_ID_ATTRIBUTE = "comments.id";
    static final String MONGO_COMMENTS_ID_ATTRIBUTE = "comments._id";
    static final String ATTACHMENTS_ID_ATTRIBUTE = "attachments.id";
    static final String MONGO_ATTACHMENTS_ID_ATTRIBUTE = "attachments._id";

    public Class<UserTaskInstanceEntity> getEntityClass() {
        return UserTaskInstanceEntity.class;
    }

    public UserTaskInstanceEntity mapToEntity(String key, UserTaskInstance instance) {
        if (instance == null) {
            return null;
        }
        UserTaskInstanceEntity entity = new UserTaskInstanceEntity();
        entity.setId(instance.getId());
        entity.setDescription(instance.getDescription());
        entity.setName(instance.getName());
        entity.setPriority(instance.getPriority());
        entity.setProcessInstanceId(instance.getProcessInstanceId());
        entity.setState(instance.getState());
        entity.setActualOwner(instance.getActualOwner());
        entity.setAdminGroups(instance.getAdminGroups());
        entity.setAdminUsers(instance.getAdminUsers());
        entity.setCompleted(ModelUtils.zonedDateTimeToInstant((ZonedDateTime)instance.getCompleted()));
        entity.setStarted(ModelUtils.zonedDateTimeToInstant((ZonedDateTime)instance.getStarted()));
        entity.setExcludedUsers(instance.getExcludedUsers());
        entity.setPotentialGroups(instance.getPotentialGroups());
        entity.setPotentialUsers(instance.getPotentialUsers());
        entity.setReferenceName(instance.getReferenceName());
        entity.setLastUpdate(ModelUtils.zonedDateTimeToInstant((ZonedDateTime)instance.getLastUpdate()));
        entity.setProcessId(instance.getProcessId());
        entity.setRootProcessId(instance.getRootProcessId());
        entity.setRootProcessInstanceId(instance.getRootProcessInstanceId());
        entity.setInputs(ModelUtils.jsonNodeToDocument((JsonNode)instance.getInputs()));
        entity.setOutputs(ModelUtils.jsonNodeToDocument((JsonNode)instance.getOutputs()));
        entity.setEndpoint(instance.getEndpoint());
        entity.setComments(Optional.ofNullable(instance.getComments()).map(comments -> comments.stream().map(this::fromComment).collect(Collectors.toList())).orElse(null));
        entity.setAttachments(Optional.ofNullable(instance.getAttachments()).map(attachments -> attachments.stream().map(this::fromAttachment).collect(Collectors.toList())).orElse(null));
        return entity;
    }

    public UserTaskInstance mapToModel(UserTaskInstanceEntity entity) {
        if (entity == null) {
            return null;
        }
        UserTaskInstance instance = new UserTaskInstance();
        instance.setId(entity.getId());
        instance.setDescription(entity.getDescription());
        instance.setName(entity.getName());
        instance.setPriority(entity.getPriority());
        instance.setProcessInstanceId(entity.getProcessInstanceId());
        instance.setState(entity.getState());
        instance.setActualOwner(entity.getActualOwner());
        instance.setAdminGroups(entity.getAdminGroups());
        instance.setAdminUsers(entity.getAdminUsers());
        instance.setCompleted(ModelUtils.instantToZonedDateTime((Long)entity.getCompleted()));
        instance.setStarted(ModelUtils.instantToZonedDateTime((Long)entity.getStarted()));
        instance.setExcludedUsers(entity.getExcludedUsers());
        instance.setPotentialGroups(entity.getPotentialGroups());
        instance.setPotentialUsers(entity.getPotentialUsers());
        instance.setReferenceName(entity.getReferenceName());
        instance.setLastUpdate(ModelUtils.instantToZonedDateTime((Long)entity.getLastUpdate()));
        instance.setProcessId(entity.getProcessId());
        instance.setRootProcessId(entity.getRootProcessId());
        instance.setRootProcessInstanceId(entity.getRootProcessInstanceId());
        instance.setInputs(ModelUtils.documentToJsonNode((Document)entity.getInputs()));
        instance.setOutputs(ModelUtils.documentToJsonNode((Document)entity.getOutputs()));
        instance.setEndpoint(entity.getEndpoint());
        instance.setComments((List)Optional.ofNullable(entity.getComments()).map(comments -> comments.stream().map(this::toComment).collect(Collectors.toList())).orElse(null));
        instance.setAttachments((List)Optional.ofNullable(entity.getAttachments()).map(attachments -> attachments.stream().map(this::toAttachment).collect(Collectors.toList())).orElse(null));
        return instance;
    }

    public String convertToMongoAttribute(String attribute) {
        if (COMMENTS_ID_ATTRIBUTE.equals(attribute)) {
            return MONGO_COMMENTS_ID_ATTRIBUTE;
        }
        if (ATTACHMENTS_ID_ATTRIBUTE.equals(attribute)) {
            return MONGO_ATTACHMENTS_ID_ATTRIBUTE;
        }
        return super.convertToMongoAttribute(attribute);
    }

    public String convertToModelAttribute(String attribute) {
        if (MONGO_COMMENTS_ID_ATTRIBUTE.equals(attribute)) {
            return "id";
        }
        if (MONGO_ATTACHMENTS_ID_ATTRIBUTE.equals(attribute)) {
            return "id";
        }
        return super.convertToModelAttribute(attribute);
    }

    Comment toComment(UserTaskInstanceEntity.CommentEntity entity) {
        if (entity == null) {
            return null;
        }
        Comment comment = new Comment();
        comment.setId(entity.getId());
        comment.setContent(entity.getContent());
        comment.setUpdatedBy(entity.getUpdatedBy());
        comment.setUpdatedAt(ModelUtils.instantToZonedDateTime((Long)entity.getUpdatedAt()));
        return comment;
    }

    UserTaskInstanceEntity.CommentEntity fromComment(Comment comment) {
        if (comment == null) {
            return null;
        }
        UserTaskInstanceEntity.CommentEntity entity = new UserTaskInstanceEntity.CommentEntity();
        entity.setId(comment.getId());
        entity.setContent(comment.getContent());
        entity.setUpdatedAt(ModelUtils.zonedDateTimeToInstant((ZonedDateTime)comment.getUpdatedAt()));
        entity.setUpdatedBy(comment.getUpdatedBy());
        return entity;
    }

    Attachment toAttachment(UserTaskInstanceEntity.AttachmentEntity entity) {
        if (entity == null) {
            return null;
        }
        Attachment attachment = new Attachment();
        attachment.setId(entity.getId());
        attachment.setContent(entity.getContent());
        attachment.setName(entity.getName());
        attachment.setUpdatedBy(entity.getUpdatedBy());
        attachment.setUpdatedAt(ModelUtils.instantToZonedDateTime((Long)entity.getUpdatedAt()));
        return attachment;
    }

    UserTaskInstanceEntity.AttachmentEntity fromAttachment(Attachment attachment) {
        if (attachment == null) {
            return null;
        }
        UserTaskInstanceEntity.AttachmentEntity entity = new UserTaskInstanceEntity.AttachmentEntity();
        entity.setId(attachment.getId());
        entity.setContent(attachment.getContent());
        entity.setName(attachment.getName());
        entity.setUpdatedAt(ModelUtils.zonedDateTimeToInstant((ZonedDateTime)attachment.getUpdatedAt()));
        entity.setUpdatedBy(attachment.getUpdatedBy());
        return entity;
    }
}

