/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.common.core.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.File;
import java.io.IOException;
import org.kie.efesto.common.api.identifiers.ModelLocalUriId;
import org.kie.efesto.common.api.io.IndexFile;
import org.kie.efesto.common.api.model.GeneratedResource;
import org.kie.efesto.common.api.model.GeneratedResources;
import org.kie.efesto.common.core.serialization.ModelLocalUriIdDeSerializer;
import org.kie.efesto.common.core.serialization.ModelLocalUriIdSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONUtils {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final Logger logger;

    private JSONUtils() {
    }

    public static String getGeneratedResourceString(GeneratedResource generatedResource) throws JsonProcessingException {
        return objectMapper.writeValueAsString((Object)generatedResource);
    }

    public static GeneratedResource getGeneratedResourceObject(String generatedResourceString) throws JsonProcessingException {
        return (GeneratedResource)objectMapper.readValue(generatedResourceString, GeneratedResource.class);
    }

    public static String getGeneratedResourcesString(GeneratedResources generatedResources) throws JsonProcessingException {
        return objectMapper.writeValueAsString((Object)generatedResources);
    }

    public static GeneratedResources getGeneratedResourcesObject(String generatedResourcesString) throws JsonProcessingException {
        return (GeneratedResources)objectMapper.readValue(generatedResourcesString, GeneratedResources.class);
    }

    public static GeneratedResources getGeneratedResourcesObject(IndexFile indexFile) throws IOException {
        logger.debug("getGeneratedResourcesObject {}", (Object)indexFile);
        logger.debug("indexFile.length() {}", (Object)indexFile.length());
        return indexFile.length() == 0L ? new GeneratedResources() : (GeneratedResources)objectMapper.readValue(indexFile.getContent(), GeneratedResources.class);
    }

    public static void writeGeneratedResourcesObject(GeneratedResources toWrite, IndexFile indexFile) throws IOException {
        objectMapper.writeValue((File)indexFile, (Object)toWrite);
    }

    public static String getModelLocalUriIdString(ModelLocalUriId localUriId) throws JsonProcessingException {
        return objectMapper.writeValueAsString((Object)localUriId);
    }

    public static ModelLocalUriId getModelLocalUriIdObject(String localUriString) throws JsonProcessingException {
        return (ModelLocalUriId)objectMapper.readValue(localUriString, ModelLocalUriId.class);
    }

    static {
        SimpleModule toRegister = new SimpleModule();
        toRegister.addDeserializer(ModelLocalUriId.class, (JsonDeserializer)new ModelLocalUriIdDeSerializer());
        toRegister.addSerializer(ModelLocalUriId.class, (JsonSerializer)new ModelLocalUriIdSerializer());
        objectMapper.registerModule((Module)toRegister);
        logger = LoggerFactory.getLogger((String)JSONUtils.class.getName());
    }
}

