/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.common.api.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.kie.efesto.common.api.exceptions.KieEfestoCommonException;
import org.kie.efesto.common.api.io.MemoryFile;
import org.kie.efesto.common.api.utils.FileNameUtils;
import org.kie.efesto.common.api.utils.MemoryFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IndexFile
extends File {
    public static final String INDEX_FILE = "IndexFile";
    public static final String FINAL_SUFFIX = "_json";
    private static final long serialVersionUID = -3471854812784089038L;
    private static final Logger logger = LoggerFactory.getLogger(IndexFile.class);
    private MemoryFile memoryFile;

    static String getIndexFileName(String modelType) {
        return String.format("%s.%s%s", INDEX_FILE, modelType, FINAL_SUFFIX);
    }

    static String validatePathName(String toValidate) {
        String fileName = FileNameUtils.getFileName(toValidate);
        if (!fileName.endsWith(FINAL_SUFFIX)) {
            throw new KieEfestoCommonException("Wrong file name " + fileName);
        }
        String model = IndexFile.getModel(fileName);
        if (model.isEmpty()) {
            throw new KieEfestoCommonException("Wrong file name " + fileName);
        }
        return toValidate;
    }

    static String getModel(String fileName) {
        return FileNameUtils.getSuffix(fileName).replace(FINAL_SUFFIX, "");
    }

    public IndexFile(String modelType) {
        super(IndexFile.validatePathName(IndexFile.getIndexFileName(modelType)));
        logger.debug("IndexFile {}", (Object)modelType);
        logger.debug(this.getAbsolutePath());
    }

    public IndexFile(String parent, String modelType) {
        super(parent, IndexFile.validatePathName(IndexFile.getIndexFileName(modelType)));
        logger.debug("IndexFile {} {}", (Object)parent, (Object)modelType);
        logger.debug(this.getAbsolutePath());
    }

    public IndexFile(File existingFile) {
        super(existingFile.toURI());
        logger.debug("IndexFile {}", (Object)existingFile);
        logger.debug(this.getAbsolutePath());
    }

    public IndexFile(MemoryFile memoryFile) {
        super(memoryFile.getName());
        this.memoryFile = memoryFile;
        logger.debug("IndexFile {}", (Object)memoryFile);
        logger.debug(this.getAbsolutePath());
        logger.debug("memoryFile {}", (Object)memoryFile.getAbsolutePath());
    }

    public String getModel() {
        return IndexFile.getModel(this.getSuffix());
    }

    @Override
    public long length() {
        return this.memoryFile != null ? this.memoryFile.length() : super.length();
    }

    public byte[] getContent() {
        return this.memoryFile != null ? this.memoryFile.getContent() : this.readContent();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IndexFile) {
            if (this.equalsByExists((IndexFile)obj)) {
                if (this.exists()) {
                    return this.equalsByIsSameFile((IndexFile)obj);
                }
                return Objects.equals(this.getAbsoluteFile().getAbsolutePath(), ((IndexFile)obj).getAbsoluteFile().getAbsolutePath());
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    private boolean equalsByExists(IndexFile toCompare) {
        return this.exists() == toCompare.exists();
    }

    private boolean equalsByIsSameFile(IndexFile toCompare) {
        try {
            return Files.isSameFile(this.toPath(), toCompare.toPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] readContent() {
        byte[] byArray;
        FileInputStream input = new FileInputStream(this);
        try {
            int read;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] bytes = new byte[1024];
            while ((read = ((InputStream)input).read(bytes)) != -1) {
                out.write(bytes, 0, read);
            }
            byte[] toReturn = out.toByteArray();
            out.flush();
            out.close();
            byArray = toReturn;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)input).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                logger.warn("Failed to read content of {} ", (Object)this, (Object)e);
                return new byte[0];
            }
        }
        ((InputStream)input).close();
        return byArray;
    }

    private String getSuffix() {
        return FileNameUtils.getSuffix(this.getName());
    }

    public static Map<String, IndexFile> findIndexFilesFromClassLoader(ClassLoader classLoader, Set<String> modelTypes) {
        logger.debug("findAllIndexFilesFromClassLoader");
        HashMap<String, IndexFile> indexFileMap = new HashMap<String, IndexFile>();
        for (String modelType : modelTypes) {
            IndexFile toSearch = new IndexFile(modelType);
            Optional<File> retrieved = MemoryFileUtils.getFileByFileNameFromClassloader(toSearch.getName(), classLoader);
            if (!retrieved.isPresent()) continue;
            File actualFile = retrieved.get();
            IndexFile toReturn = actualFile instanceof MemoryFile ? new IndexFile((MemoryFile)actualFile) : new IndexFile(actualFile);
            logger.debug("found {}", (Object)toReturn);
            if (indexFileMap.containsKey(modelType)) {
                throw new KieEfestoCommonException("Multiple IndexFiles for " + modelType + " found. " + ((IndexFile)indexFileMap.get(modelType)).getAbsolutePath() + ", " + toReturn.getAbsolutePath());
            }
            indexFileMap.put(modelType, toReturn);
        }
        return indexFileMap;
    }
}

