/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.organization.forms.login.freemarker.model;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.keycloak.forms.login.freemarker.model.IdentityProviderBean;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.IdentityProviderStorageProvider;
import org.keycloak.models.OrganizationModel;
import org.keycloak.organization.utils.Organizations;

public class OrganizationAwareIdentityProviderBean
extends IdentityProviderBean {
    private final OrganizationModel organization;
    private final boolean onlyRealmBrokers;
    private final boolean onlyOrganizationBrokers;

    public OrganizationAwareIdentityProviderBean(IdentityProviderBean delegate) {
        this(delegate, false);
    }

    public OrganizationAwareIdentityProviderBean(IdentityProviderBean delegate, boolean onlyOrganizationBrokers) {
        this(delegate, onlyOrganizationBrokers, false);
    }

    public OrganizationAwareIdentityProviderBean(IdentityProviderBean delegate, boolean onlyOrganizationBrokers, boolean onlyRealmBrokers) {
        super(delegate.getSession(), delegate.getRealm(), delegate.getBaseURI(), delegate.getFlowContext());
        this.organization = Organizations.resolveOrganization(this.session);
        this.onlyRealmBrokers = onlyRealmBrokers;
        this.onlyOrganizationBrokers = onlyOrganizationBrokers;
    }

    @Override
    protected List<IdentityProviderBean.IdentityProvider> searchForIdentityProviders(String existingIDP) {
        if (this.onlyRealmBrokers) {
            return this.session.identityProviders().getForLogin(IdentityProviderStorageProvider.FetchMode.REALM_ONLY, null).filter(idp -> !Objects.equals(existingIDP, idp.getAlias())).map(idp -> this.createIdentityProvider(this.realm, this.baseURI, (IdentityProviderModel)idp)).sorted((Comparator<IdentityProviderBean.IdentityProvider>)IDP_COMPARATOR_INSTANCE).toList();
        }
        if (this.onlyOrganizationBrokers) {
            if (this.organization != null) {
                return this.organization.getIdentityProviders().filter(idp -> idp.isEnabled() && !idp.isLinkOnly() && !idp.isHideOnLogin()).filter(idp -> !Objects.equals(existingIDP, idp.getAlias())).map(idp -> this.createIdentityProvider(this.realm, this.baseURI, (IdentityProviderModel)idp)).sorted((Comparator<IdentityProviderBean.IdentityProvider>)IDP_COMPARATOR_INSTANCE).toList();
            }
            return this.session.identityProviders().getForLogin(IdentityProviderStorageProvider.FetchMode.ORG_ONLY, null).filter(idp -> idp.isEnabled() && !Objects.equals(existingIDP, idp.getAlias())).map(idp -> this.createIdentityProvider(this.realm, this.baseURI, (IdentityProviderModel)idp)).sorted((Comparator<IdentityProviderBean.IdentityProvider>)IDP_COMPARATOR_INSTANCE).toList();
        }
        return this.session.identityProviders().getForLogin(IdentityProviderStorageProvider.FetchMode.ALL, this.organization != null ? this.organization.getId() : null).filter(idp -> idp.isEnabled() && !Objects.equals(existingIDP, idp.getAlias())).map(idp -> this.createIdentityProvider(this.realm, this.baseURI, (IdentityProviderModel)idp)).sorted((Comparator<IdentityProviderBean.IdentityProvider>)IDP_COMPARATOR_INSTANCE).toList();
    }

    @Override
    protected Predicate<IdentityProviderModel> federatedProviderPredicate() {
        return super.federatedProviderPredicate().and(idp -> {
            if (this.onlyRealmBrokers) {
                return idp.getOrganizationId() == null;
            }
            if (this.onlyOrganizationBrokers) {
                return this.isPublicOrganizationBroker((IdentityProviderModel)idp);
            }
            return idp.getOrganizationId() == null || this.isPublicOrganizationBroker((IdentityProviderModel)idp);
        });
    }

    private boolean isPublicOrganizationBroker(IdentityProviderModel idp) {
        if (idp.getOrganizationId() == null) {
            return false;
        }
        if (this.organization != null && !Objects.equals(this.organization.getId(), idp.getOrganizationId())) {
            return false;
        }
        return !idp.isHideOnLogin();
    }
}

