/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.conditional;

import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.authenticators.conditional.ConditionalAuthenticator;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public class ConditionalRoleAuthenticator
implements ConditionalAuthenticator {
    public static final ConditionalRoleAuthenticator SINGLETON = new ConditionalRoleAuthenticator();
    private static final Logger logger = Logger.getLogger(ConditionalRoleAuthenticator.class);

    @Override
    public boolean matchCondition(AuthenticationFlowContext context) {
        UserModel user = context.getUser();
        RealmModel realm = context.getRealm();
        AuthenticatorConfigModel authConfig = context.getAuthenticatorConfig();
        if (user != null && authConfig != null && authConfig.getConfig() != null) {
            String requiredRole = (String)authConfig.getConfig().get("condUserRole");
            boolean negateOutput = Boolean.parseBoolean((String)authConfig.getConfig().get("negate"));
            RoleModel role = KeycloakModelUtils.getRoleFromString((RealmModel)realm, (String)requiredRole);
            if (role == null) {
                logger.errorv("Invalid role name submitted: {0}", (Object)requiredRole);
                return false;
            }
            return negateOutput != user.hasRole(role);
        }
        return false;
    }

    public void action(AuthenticationFlowContext context) {
    }

    public boolean requiresUser() {
        return true;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public void close() {
    }
}

