/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

public class ClientScopeEvaluateScopeMappingsResource {
    private final RoleContainerModel roleContainer;
    private final AdminPermissionEvaluator auth;
    private final ClientModel client;
    private final String scopeParam;
    private final KeycloakSession session;

    public ClientScopeEvaluateScopeMappingsResource(RoleContainerModel roleContainer, AdminPermissionEvaluator auth, ClientModel client, String scopeParam, KeycloakSession session) {
        this.roleContainer = roleContainer;
        this.auth = auth;
        this.client = client;
        this.scopeParam = scopeParam;
        this.session = session;
    }

    @Path(value="/granted")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Stream<RoleRepresentation> getGrantedScopeMappings() {
        return this.getGrantedRoles().map(ModelToRepresentation::toBriefRepresentation);
    }

    @Path(value="/not-granted")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Stream<RoleRepresentation> getNotGrantedScopeMappings() {
        Set grantedRoles = this.getGrantedRoles().collect(Collectors.toSet());
        return this.roleContainer.getRolesStream().filter(((Predicate<RoleModel>)grantedRoles::contains).negate()).map(ModelToRepresentation::toBriefRepresentation);
    }

    private Stream<RoleModel> getGrantedRoles() {
        if (this.client.isFullScopeAllowed()) {
            return this.roleContainer.getRolesStream();
        }
        Set clientScopes = TokenManager.getRequestedClientScopes(this.scopeParam, this.client).collect(Collectors.toSet());
        Predicate<RoleModel> hasClientScope = role -> clientScopes.stream().anyMatch(scopeContainer -> scopeContainer.hasScope(role));
        return this.roleContainer.getRolesStream().filter(this.auth.roles()::canView).filter(hasClientScope);
    }
}

