/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.theme.ClasspathThemeProvider;
import org.keycloak.theme.ClasspathThemeProviderFactory;
import org.keycloak.theme.ThemeProvider;

public class JarThemeProviderFactory
extends ClasspathThemeProviderFactory {
    public JarThemeProviderFactory() {
        super("jar");
    }

    @Override
    public ThemeProvider create(KeycloakSession session) {
        return new ClasspathThemeProvider(themes);
    }

    @Override
    public void init(Config.Scope config) {
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            Enumeration<URL> resources = classLoader.getResources("META-INF/keycloak-themes.json");
            while (resources.hasMoreElements()) {
                this.loadThemes(classLoader, resources.nextElement().openStream());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load themes", e);
        }
    }
}

