/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.account;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.device.DeviceActivityManager;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.representations.account.ClientRepresentation;
import org.keycloak.representations.account.DeviceRepresentation;
import org.keycloak.representations.account.SessionRepresentation;
import org.keycloak.services.managers.Auth;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.resources.Cors;

public class SessionResource {
    private final KeycloakSession session;
    private final Auth auth;
    private final RealmModel realm;
    private final UserModel user;
    private HttpRequest request;

    public SessionResource(KeycloakSession session, Auth auth, HttpRequest request) {
        this.session = session;
        this.auth = auth;
        this.realm = auth.getRealm();
        this.user = auth.getUser();
        this.request = request;
    }

    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Response toRepresentation() {
        return Cors.add(this.request, Response.ok(this.session.sessions().getUserSessions(this.realm, this.user).stream().map(this::toRepresentation).collect(Collectors.toList()))).auth().allowedOrigins(this.auth.getToken()).build();
    }

    @Path(value="devices")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Response devices() {
        HashMap<String, DeviceRepresentation> reps = new HashMap<String, DeviceRepresentation>();
        List sessions = this.session.sessions().getUserSessions(this.realm, this.user);
        for (UserSessionModel s : sessions) {
            DeviceRepresentation device = this.getAttachedDevice(s);
            DeviceRepresentation rep = reps.computeIfAbsent(device.getOs() + device.getOsVersion(), key -> {
                DeviceRepresentation representation = new DeviceRepresentation();
                representation.setLastAccess(device.getLastAccess());
                representation.setOs(device.getOs());
                representation.setOsVersion(device.getOsVersion());
                representation.setDevice(device.getDevice());
                representation.setMobile(device.isMobile());
                return representation;
            });
            if (this.isCurrentSession(s)) {
                rep.setCurrent(Boolean.valueOf(true));
            }
            if (rep.getLastAccess() == 0 || rep.getLastAccess() < s.getLastSessionRefresh()) {
                rep.setLastAccess(s.getLastSessionRefresh());
            }
            rep.addSession(this.createSessionRepresentation(s, device));
        }
        return Cors.add(this.request, Response.ok(reps.values())).auth().allowedOrigins(this.auth.getToken()).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @NoCache
    public Response logout(@QueryParam(value="current") boolean removeCurrent) {
        this.auth.require("manage-account");
        List userSessions = this.session.sessions().getUserSessions(this.realm, this.user);
        for (UserSessionModel s : userSessions) {
            if (!removeCurrent && this.isCurrentSession(s)) continue;
            AuthenticationManager.backchannelLogout(this.session, s, true);
        }
        return Cors.add(this.request, Response.noContent()).auth().allowedOrigins(this.auth.getToken()).build();
    }

    @Path(value="/{id}")
    @DELETE
    @Produces(value={"application/json"})
    @NoCache
    public Response logout(@PathParam(value="id") String id) {
        this.auth.require("manage-account");
        UserSessionModel userSession = this.session.sessions().getUserSession(this.realm, id);
        if (userSession != null && userSession.getUser().equals(this.user)) {
            AuthenticationManager.backchannelLogout(this.session, userSession, true);
        }
        return Cors.add(this.request, Response.noContent()).auth().allowedOrigins(this.auth.getToken()).build();
    }

    private SessionRepresentation createSessionRepresentation(UserSessionModel s, DeviceRepresentation device) {
        SessionRepresentation sessionRep = new SessionRepresentation();
        sessionRep.setId(s.getId());
        sessionRep.setIpAddress(s.getIpAddress());
        sessionRep.setStarted(s.getStarted());
        sessionRep.setLastAccess(s.getLastSessionRefresh());
        sessionRep.setExpires(s.getStarted() + this.realm.getSsoSessionMaxLifespan());
        sessionRep.setBrowser(device.getBrowser());
        if (this.isCurrentSession(s)) {
            sessionRep.setCurrent(Boolean.valueOf(true));
        }
        sessionRep.setClients(new LinkedList());
        for (String clientUUID : s.getAuthenticatedClientSessions().keySet()) {
            ClientModel client = this.realm.getClientById(clientUUID);
            ClientRepresentation clientRep = new ClientRepresentation();
            clientRep.setClientId(client.getClientId());
            clientRep.setClientName(client.getName());
            sessionRep.getClients().add(clientRep);
        }
        return sessionRep;
    }

    private DeviceRepresentation getAttachedDevice(UserSessionModel s) {
        DeviceRepresentation device = DeviceActivityManager.getCurrentDevice((UserSessionModel)s);
        if (device == null) {
            device = DeviceRepresentation.unknown();
            device.setIpAddress(s.getIpAddress());
        }
        return device;
    }

    private boolean isCurrentSession(UserSessionModel session) {
        return session.getId().equals(this.auth.getSession().getId());
    }

    private SessionRepresentation toRepresentation(UserSessionModel s) {
        return this.createSessionRepresentation(s, this.getAttachedDevice(s));
    }
}

