/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml.mappers;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.dom.saml.v2.assertion.AudienceRestrictionType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.saml.mappers.AbstractSAMLProtocolMapper;
import org.keycloak.protocol.saml.mappers.SAMLAudienceProtocolMapper;
import org.keycloak.protocol.saml.mappers.SAMLLoginResponseMapper;
import org.keycloak.provider.ProviderConfigProperty;

public class SAMLAudienceResolveProtocolMapper
extends AbstractSAMLProtocolMapper
implements SAMLLoginResponseMapper {
    protected static final Logger logger = Logger.getLogger(SAMLAudienceResolveProtocolMapper.class);
    public static final String PROVIDER_ID = "saml-audience-resolve-mapper";
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "Audience Resolve";
    }

    public String getDisplayCategory() {
        return "Audience mapper";
    }

    public String getHelpText() {
        return "Adds all client_ids of \"allowed\" clients to the audience conditions in the assertion. Allowed client means any SAML client for which user has at least one client role";
    }

    @Override
    public ResponseType transformLoginResponse(ResponseType response, ProtocolMapperModel mappingModel, KeycloakSession session, UserSessionModel userSession, ClientSessionContext clientSessionCtx) {
        AudienceRestrictionType aud = SAMLAudienceProtocolMapper.locateAudienceRestriction(response);
        if (aud != null) {
            Set roles = clientSessionCtx.getRoles();
            HashSet<String> audiences = new HashSet<String>();
            for (RoleModel role : roles) {
                ClientModel app;
                logger.tracef("Managing role: %s", (Object)role.getName());
                if (!role.isClientRole() || !"saml".equals((app = (ClientModel)role.getContainer()).getProtocol()) || app.getClientId().equals(clientSessionCtx.getClientSession().getClient().getClientId())) continue;
                audiences.add(app.getClientId());
            }
            logger.debugf("Calculated audiences to add: %s", audiences);
            for (String audience : audiences) {
                try {
                    aud.addAudience(URI.create(audience));
                }
                catch (IllegalArgumentException e) {
                    logger.warnf((Throwable)e, "Invalid URI syntax for audience: %s", (Object)audience);
                }
            }
        }
        return response;
    }
}

