/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import org.jboss.logging.Logger;
import org.keycloak.migration.MigrationProvider;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.migration.migrators.MigrationUtils;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.RealmRepresentation;

public class MigrateTo6_0_0
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("6.0.0");
    private static final Logger LOG = Logger.getLogger(MigrateTo6_0_0.class);

    @Override
    public ModelVersion getVersion() {
        return VERSION;
    }

    @Override
    public void migrate(KeycloakSession session) {
        session.realms().getRealmsStream().forEach(realm -> this.migrateRealm(session, (RealmModel)realm, false));
    }

    @Override
    public void migrateImport(KeycloakSession session, RealmModel realm, RealmRepresentation rep, boolean skipUserDependent) {
        this.migrateRealm(session, realm, true);
    }

    protected void migrateRealm(KeycloakSession session, RealmModel realm, boolean jsn) {
        MigrationProvider migrationProvider = (MigrationProvider)session.getProvider(MigrationProvider.class);
        ClientScopeModel mpJWTScope = migrationProvider.addOIDCMicroprofileJWTClientScope(realm);
        LOG.debugf("Added '%s' optional client scope", (Object)mpJWTScope.getName());
        realm.getClientsStream().filter(MigrationUtils::isOIDCNonBearerOnlyClient).forEach(c -> c.addClientScope(mpJWTScope, false));
        LOG.debugf("Client scope '%s' assigned to all the clients", (Object)mpJWTScope.getName());
    }
}

