/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.integration.jaxrs;

import java.io.IOException;
import java.util.stream.Stream;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.ext.Provider;
import org.keycloak.common.util.Resteasy;
import org.keycloak.models.KeycloakSession;
import org.keycloak.quarkus.runtime.transaction.TransactionalSessionHandler;

@Provider
@PreMatching
@Priority(value=1)
public class TransactionalResponseFilter
implements ContainerResponseFilter,
TransactionalSessionHandler {
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        Object entity = responseContext.getEntity();
        if (TransactionalResponseFilter.shouldDelaySessionClose(entity)) {
            return;
        }
        this.close((KeycloakSession)Resteasy.getContextData(KeycloakSession.class));
    }

    private static boolean shouldDelaySessionClose(Object entity) {
        return entity instanceof Stream || entity instanceof StreamingOutput;
    }
}

