/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import java.io.StringWriter;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.expression.Expression;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.type.Type;

public abstract class OperExpression
extends Expression {
    protected int oper;
    public static final int UNARY = 65536;
    public static final int BINARY = 131072;
    public static final int TERNARY = 262144;
    public static final int NOT = 65552;
    public static final int TWIDDLE = 65568;
    public static final int OR = 131136;
    public static final int AND = 131137;
    public static final int EQ = 131200;
    public static final int NE = 131201;
    public static final int GT = 131202;
    public static final int LT = 131203;
    public static final int GE = 131204;
    public static final int LE = 131205;
    public static final int BOR = 131328;
    public static final int BAND = 131329;
    public static final int BXOR = 131330;
    public static final int URSH = 131331;
    public static final int RSH = 131332;
    public static final int LSH = 131333;
    public static final int INSTANCEOF = 131584;
    public static final int UMINUS = 66560;
    public static final int MUL = 132097;
    public static final int DIV = 132098;
    public static final int PLUS = 132099;
    public static final int MINUS = 132100;
    public static final int MOD = 132101;
    public static final int ASSIGN = 133120;
    public static final int COND = 266240;
    private static final int[] operands = new int[]{65552, 65568, 131136, 131137, 131200, 131201, 131202, 131203, 131204, 131205, 131328, 131329, 131330, 131331, 131332, 131333, 131584, 66560, 132097, 132098, 132099, 132100, 132101, 133120, 266240};
    private static final int[] parserOperands = new int[]{45, 48, 46, 30, 36, 44, 38, 40, 37, 39, 32, 31, 33, 52, 51, 50, 53, 49, 43, 34, 47, 41, 42, 1, 17};
    private static final String[] operandNames = new String[]{"!", "~", "||", "&&", "==", "!=", ">", "<", ">=", "<=", "|", "&", "^", ">>>", ">>", "<<", "instanceof", "-", "*", "/", "+", "-", "%", "=", "? :"};

    OperExpression(Rule rule, int oper, Type type, ParseNode token) {
        super(rule, type, token);
        this.oper = oper;
    }

    public abstract Expression getOperand(int var1);

    @Override
    public void writeTo(StringWriter stringWriter) {
        if ((this.oper & 0x10000) != 0) {
            stringWriter.write(this.getOperandString());
            stringWriter.write("(");
            this.getOperand(0).writeTo(stringWriter);
            stringWriter.write(")");
        } else if ((this.oper & 0x20000) != 0) {
            stringWriter.write("(");
            this.getOperand(0).writeTo(stringWriter);
            stringWriter.write(" ");
            stringWriter.write(this.getOperandString());
            stringWriter.write(" ");
            this.getOperand(1).writeTo(stringWriter);
            stringWriter.write(")");
        } else if (this.oper == 266240) {
            stringWriter.write("(");
            this.getOperand(0).writeTo(stringWriter);
            stringWriter.write(" ? ");
            this.getOperand(1).writeTo(stringWriter);
            stringWriter.write(" : ");
            this.getOperand(2).writeTo(stringWriter);
            stringWriter.write(")");
        } else {
            stringWriter.write("*** error unknown operator *** " + this.oper);
        }
    }

    private String getOperandString() {
        for (int i = 0; i < operands.length; ++i) {
            if (operands[i] != this.oper) continue;
            return operandNames[i];
        }
        return "*** error unknown operator ***";
    }

    public static int convertOper(int parserOper) {
        for (int i = 0; i < parserOperands.length; ++i) {
            if (parserOperands[i] != parserOper) continue;
            return operands[i];
        }
        return -1;
    }
}

