/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.webauthn4j.util.AssertUtil;
import java.io.Serializable;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AuthenticatorTransport
implements Serializable {
    public static final AuthenticatorTransport USB = new AuthenticatorTransport("usb");
    public static final AuthenticatorTransport NFC = new AuthenticatorTransport("nfc");
    public static final AuthenticatorTransport BLE = new AuthenticatorTransport("ble");
    public static final AuthenticatorTransport INTERNAL = new AuthenticatorTransport("internal");
    private final String value;

    private AuthenticatorTransport(@NonNull String value) {
        this.value = value;
    }

    public static @NonNull AuthenticatorTransport create(@NonNull String value) {
        AssertUtil.notNull((Object)value, (String)"value must not be null.");
        return new AuthenticatorTransport(value);
    }

    @JsonCreator
    static @NonNull AuthenticatorTransport deserialize(@NonNull String value) throws InvalidFormatException {
        try {
            return AuthenticatorTransport.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, AuthenticatorTransport.class);
        }
    }

    @JsonValue
    public @NonNull String getValue() {
        return this.value;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorTransport that = (AuthenticatorTransport)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value;
    }
}

