/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.registration.cli.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.jboss.aesh.console.AeshConsoleBufferBuilder;
import org.jboss.aesh.console.AeshInputProcessorBuilder;
import org.jboss.aesh.console.ConsoleBuffer;
import org.jboss.aesh.console.InputProcessor;
import org.jboss.aesh.console.Prompt;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.keycloak.client.registration.cli.aesh.Globals;
import org.keycloak.client.registration.cli.util.OsUtil;

public class IoUtil {
    public static String readFileOrStdin(String file) {
        String content;
        if ("-".equals(file)) {
            content = IoUtil.readFully(System.in);
        } else {
            try (FileInputStream is = new FileInputStream(file);){
                content = IoUtil.readFully(is);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("File not found: " + file);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read file: " + file, e);
            }
        }
        return content;
    }

    public static void waitFor(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted");
        }
    }

    public static String readSecret(String prompt, CommandInvocation invocation) {
        String result;
        char maskChar = OsUtil.OS_ARCH.isWindows() ? (char)'\u0000' : '*';
        ConsoleBuffer consoleBuffer = new AeshConsoleBufferBuilder().shell(invocation.getShell()).prompt(new Prompt(prompt, Character.valueOf(maskChar))).create();
        InputProcessor inputProcessor = new AeshInputProcessorBuilder().consoleBuffer(consoleBuffer).create();
        consoleBuffer.displayPrompt();
        Globals.stdin.setInputStream(System.in);
        try {
            while ((result = inputProcessor.parseOperation(invocation.getInput())) == null) {
            }
        }
        catch (Exception e) {
            throw new RuntimeException("^C", e);
        }
        result = result.replaceAll("\\n", "");
        return result;
    }

    public static String readFully(InputStream is) {
        Charset charset = Charset.forName("utf-8");
        StringBuilder out = new StringBuilder();
        byte[] buf = new byte[8192];
        try {
            int rc;
            while ((rc = is.read(buf)) != -1) {
                out.append(new String(buf, 0, rc, charset));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read stream", e);
        }
        return out.toString();
    }

    public static void ensureFile(Path path) throws IOException {
        FileSystem fs = FileSystems.getDefault();
        Set<String> supportedViews = fs.supportedFileAttributeViews();
        Path parent = path.getParent();
        if (!Files.isDirectory(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
            if (supportedViews.contains("posix")) {
                IoUtil.setUnixPermissions(parent);
            } else if (supportedViews.contains("acl")) {
                IoUtil.setWindowsPermissions(parent);
            } else {
                IoUtil.warnErr("Failed to restrict access permissions on .keycloak directory: " + parent);
            }
        }
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            Files.createFile(path, new FileAttribute[0]);
            if (FileSystems.getDefault().supportedFileAttributeViews().contains("posix")) {
                IoUtil.setUnixPermissions(path);
            } else if (supportedViews.contains("acl")) {
                IoUtil.setWindowsPermissions(path);
            } else {
                IoUtil.warnErr("Failed to restrict access permissions on config file: " + path);
            }
        }
    }

    private static void setUnixPermissions(Path path) throws IOException {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.OWNER_WRITE);
        if (Files.isDirectory(path, new LinkOption[0])) {
            perms.add(PosixFilePermission.OWNER_EXECUTE);
        }
        Files.setPosixFilePermissions(path, perms);
    }

    private static void setWindowsPermissions(Path path) throws IOException {
        AclEntry entry;
        AclFileAttributeView view = Files.getFileAttributeView(path, AclFileAttributeView.class, new LinkOption[0]);
        UserPrincipal owner = view.getOwner();
        List<AclEntry> acl = view.getAcl();
        ListIterator<AclEntry> it = acl.listIterator();
        while (it.hasNext()) {
            entry = it.next();
            if ("BUILTIN\\Administrators".equals(entry.principal().getName()) || "NT AUTHORITY\\SYSTEM".equals(entry.principal().getName())) continue;
            it.remove();
        }
        entry = AclEntry.newBuilder().setType(AclEntryType.ALLOW).setPrincipal(owner).setPermissions(AclEntryPermission.READ_DATA, AclEntryPermission.WRITE_DATA, AclEntryPermission.APPEND_DATA, AclEntryPermission.READ_NAMED_ATTRS, AclEntryPermission.WRITE_NAMED_ATTRS, AclEntryPermission.EXECUTE, AclEntryPermission.READ_ATTRIBUTES, AclEntryPermission.WRITE_ATTRIBUTES, AclEntryPermission.DELETE, AclEntryPermission.READ_ACL, AclEntryPermission.SYNCHRONIZE).build();
        acl.add(entry);
        view.setAcl(acl);
    }

    public static void printOut(String msg) {
        System.out.println(msg);
    }

    public static void printErr(String msg) {
        System.err.println(msg);
    }

    public static void printfOut(String format, String ... params) {
        System.out.println(new Formatter().format("WARN: " + format, params));
    }

    public static void warnOut(String msg) {
        System.out.println("WARN: " + msg);
    }

    public static void warnErr(String msg) {
        System.err.println("WARN: " + msg);
    }

    public static void warnfOut(String format, String ... params) {
        System.out.println(new Formatter().format("WARN: " + format, params));
    }

    public static void warnfErr(String format, String ... params) {
        System.err.println(new Formatter().format("WARN: " + format, params));
    }

    public static void logOut(String msg) {
        System.out.println("LOG: " + msg);
    }
}

