/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.asyncutil.util;

import com.ibm.asyncutil.util.StageSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class Combinators {
    private static final int MAX_DEPENDANT_DEPTH = 256;

    private Combinators() {
    }

    public static CompletionStage<Void> allOf(Collection<? extends CompletionStage<?>> stages) {
        final Iterator backingIt = stages.iterator();
        int size = stages.size();
        Iterator it = size > 256 ? new Iterator<CompletionStage<?>>(){

            @Override
            public boolean hasNext() {
                return backingIt.hasNext();
            }

            @Override
            public CompletionStage<?> next() {
                return ((CompletionStage)backingIt.next()).toCompletableFuture();
            }
        } : backingIt;
        return Combinators.allOfImpl(it);
    }

    private static CompletionStage<Void> allOfImpl(Iterator<? extends CompletionStage<?>> it) {
        CompletionStage<Void> accumulator = StageSupport.voidStage();
        while (it.hasNext()) {
            accumulator = accumulator.thenCombine(it.next(), (l, r) -> null);
        }
        return accumulator;
    }

    public static <T> CompletionStage<Collection<T>> collect(Collection<? extends CompletionStage<T>> stages) {
        return Combinators.collect(stages, Collectors.toCollection(() -> new ArrayList(stages.size())));
    }

    private static <T, A, R> CompletionStage<R> collectImpl(Iterator<? extends CompletionStage<T>> it, Collector<? super T, A, R> collector) {
        CompletionStage<Object> acc = StageSupport.completedStage(collector.supplier().get());
        BiConsumer accFun = collector.accumulator();
        while (it.hasNext()) {
            acc = acc.thenCombine(it.next(), (a, t) -> {
                accFun.accept(a, t);
                return a;
            });
        }
        return collector.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH) ? acc : acc.thenApply(collector.finisher());
    }

    public static <T, A, R> CompletionStage<R> collect(Collection<? extends CompletionStage<T>> stages, Collector<? super T, A, R> collector) {
        int size = stages.size();
        final Iterator backingIt = stages.iterator();
        Iterator it = size > 256 ? new Iterator<CompletionStage<T>>(){

            @Override
            public boolean hasNext() {
                return backingIt.hasNext();
            }

            @Override
            public CompletionStage<T> next() {
                return ((CompletionStage)backingIt.next()).toCompletableFuture();
            }
        } : backingIt;
        return Combinators.collectImpl(it, collector);
    }

    public static <K, V> CompletionStage<Map<K, V>> keyedAll(Map<K, ? extends CompletionStage<V>> stageMap) {
        return Combinators.allOf(stageMap.values()).thenApply(ignore -> stageMap.entrySet().stream().collect(Collectors.toMap(e -> e.getKey(), e -> ((CompletionStage)e.getValue()).toCompletableFuture().join())));
    }
}

