/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.rotation;

import java.security.Key;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import org.keycloak.rotation.KeyLocator;

public class HardcodedKeyLocator
implements KeyLocator,
Iterable<Key> {
    private final Collection<? extends Key> keys;

    public HardcodedKeyLocator(Key key) {
        this.keys = Collections.singleton(key);
    }

    public HardcodedKeyLocator(Collection<? extends Key> keys) {
        if (keys == null) {
            throw new NullPointerException("keys");
        }
        this.keys = new LinkedList<Key>(keys);
    }

    @Override
    public Key getKey(String kid) {
        if (this.keys.size() == 1) {
            return this.keys.iterator().next();
        }
        return null;
    }

    @Override
    public void refreshKeyCache() {
    }

    public String toString() {
        return "hardcoded keys, count: " + this.keys.size();
    }

    @Override
    public Iterator<Key> iterator() {
        return Collections.unmodifiableCollection(this.keys).iterator();
    }
}

