/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.okhttp;

import com.openshift.internal.restclient.DefaultClient;
import com.openshift.internal.restclient.authorization.AuthorizationDetails;
import com.openshift.internal.restclient.model.Status;
import com.openshift.internal.util.URIUtils;
import com.openshift.restclient.BadRequestException;
import com.openshift.restclient.IClient;
import com.openshift.restclient.NotFoundException;
import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.authorization.ResourceForbiddenException;
import com.openshift.restclient.authorization.UnauthorizedException;
import com.openshift.restclient.http.IHttpConstants;
import com.openshift.restclient.model.IStatus;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Response;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseCodeInterceptor
implements Interceptor,
IHttpConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResponseCodeInterceptor.class);
    public static final String X_OPENSHIFT_IGNORE_RCI = "X-OPENSHIFT-IGNORE-RCI";
    private IClient client;

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response = chain.proceed(chain.request());
        if (!response.isSuccessful() && StringUtils.isBlank((String)response.request().header(X_OPENSHIFT_IGNORE_RCI))) {
            switch (response.code()) {
                case 101: 
                case 301: {
                    break;
                }
                case 302: {
                    response = this.makeSuccessIfAuthorized(response);
                    break;
                }
                default: {
                    if (this.isIgnoreTagged(response)) break;
                    throw ResponseCodeInterceptor.createOpenShiftException(this.client, response, null);
                }
            }
        }
        return response;
    }

    private boolean isIgnoreTagged(Response response) {
        return response.request().tag() instanceof Ignore;
    }

    private Response makeSuccessIfAuthorized(Response response) {
        Response returnedResponse = response;
        String location = response.header("Location");
        if (StringUtils.isNotBlank((String)location) && URIUtils.splitFragment(location).containsKey("access_token")) {
            returnedResponse = response.newBuilder().request(response.request()).code(200).headers(response.headers()).build();
            response.close();
        }
        return returnedResponse;
    }

    public void setClient(DefaultClient client) {
        this.client = client;
    }

    public static IStatus getStatus(String response) {
        if (response != null && response.startsWith("{")) {
            return new Status(response);
        }
        return null;
    }

    private static OpenShiftException createOpenShiftException(IClient client, Response response, Throwable e) throws IOException {
        LOGGER.debug(response.toString(), e);
        IStatus status = ResponseCodeInterceptor.getStatus(response.body().string());
        int responseCode = response.code();
        if (status != null && status.getCode() != 0) {
            responseCode = status.getCode();
        }
        switch (responseCode) {
            case 400: {
                return new BadRequestException(e, status, response.request().url().toString());
            }
            case 403: {
                return new ResourceForbiddenException(status != null ? status.getMessage() : "Resource Forbidden", status, e);
            }
            case 401: {
                String link = String.format("%s/oauth/token/request", client.getBaseURL());
                AuthorizationDetails details = new AuthorizationDetails(response.headers(), link);
                return new UnauthorizedException(details, status);
            }
            case 404: {
                return new NotFoundException(e, status, status == null ? "Not Found" : status.getMessage(), new Object[0]);
            }
        }
        return new OpenShiftException(e, status, "Exception trying to %s %s response code: %s", response.request().method(), response.request().url().toString(), responseCode);
    }

    public static OpenShiftException createOpenShiftException(IClient client, int responseCode, String message, String response, Throwable e) {
        LOGGER.debug(response, e);
        IStatus status = ResponseCodeInterceptor.getStatus(response);
        if (status != null && status.getCode() != 0) {
            responseCode = status.getCode();
        }
        switch (responseCode) {
            case 400: {
                return new BadRequestException(e, status, response);
            }
            case 403: {
                return new ResourceForbiddenException(status != null ? status.getMessage() : "Resource Forbidden", status, e);
            }
            case 401: {
                return new UnauthorizedException(client.getAuthorizationContext().getAuthorizationDetails(), status);
            }
            case 404: {
                return new NotFoundException(status == null ? "Not Found" : status.getMessage());
            }
        }
        return new OpenShiftException(e, status, "Exception trying to fetch %s response code: %s", response, responseCode);
    }

    public static interface Ignore {
    }
}

