/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.capability.resources;

import com.openshift.internal.restclient.DefaultClient;
import com.openshift.internal.restclient.URLBuilder;
import com.openshift.internal.restclient.okhttp.OpenShiftRequestBuilder;
import com.openshift.internal.restclient.okhttp.ResponseCodeInterceptor;
import com.openshift.restclient.IApiTypeMapper;
import com.openshift.restclient.IClient;
import com.openshift.restclient.UnsupportedEndpointException;
import com.openshift.restclient.capability.IStoppable;
import com.openshift.restclient.capability.resources.IPodLogRetrievalAsync;
import com.openshift.restclient.model.IPod;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PodLogRetrievalAsync
implements IPodLogRetrievalAsync {
    private static final Logger LOG = LoggerFactory.getLogger(PodLogRetrievalAsync.class);
    private static final String CAPABILITY = "log";
    private final IPod pod;
    private final DefaultClient client;
    private final IApiTypeMapper mapper;

    public PodLogRetrievalAsync(IPod pod, IClient client) {
        this.pod = pod;
        this.client = client.adapt(DefaultClient.class);
        this.mapper = client.adapt(IApiTypeMapper.class);
    }

    @Override
    public boolean isSupported() {
        if (this.client != null && this.mapper != null) {
            try {
                return this.mapper.getEndpointFor(this.pod.getApiVersion(), this.pod.getKind()).isSupported(CAPABILITY);
            }
            catch (UnsupportedEndpointException unsupportedEndpointException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public String getName() {
        return PodLogRetrievalAsync.class.getSimpleName();
    }

    @Override
    public IStoppable start(IPodLogRetrievalAsync.IPodLogListener listener) {
        return this.start(listener, null);
    }

    @Override
    public IStoppable start(IPodLogRetrievalAsync.IPodLogListener listener, IPodLogRetrievalAsync.Options options) {
        HashMap<String, String> parameters = options != null ? options.getMap() : new HashMap<String, String>();
        PodLogListenerAdapter adapter = new PodLogListenerAdapter(listener);
        OkHttpClient okClient = this.client.adapt(OkHttpClient.class);
        String endpoint = new URLBuilder(this.client.getBaseURL(), this.mapper).kind(this.pod.getKind()).namespace(this.pod.getNamespaceName()).name(this.pod.getName()).subresource(CAPABILITY).addParameters(parameters).websocket();
        Request request = new OpenShiftRequestBuilder().url(endpoint).acceptJson().authorization(this.client.getAuthorizationContext()).tag(new ResponseCodeInterceptor.Ignore(){}).build();
        okClient.newWebSocket(request, (WebSocketListener)adapter);
        return adapter;
    }

    static class PodLogListenerAdapter
    extends WebSocketListener
    implements IStoppable {
        private final IPodLogRetrievalAsync.IPodLogListener listener;
        private WebSocket wsClient;
        private AtomicBoolean open = new AtomicBoolean(false);

        public PodLogListenerAdapter(IPodLogRetrievalAsync.IPodLogListener listener) {
            this.listener = listener;
        }

        @Override
        public void stop() {
            try {
                if (this.open.get()) {
                    this.wsClient.close(1000, "Client asking to stop.");
                }
            }
            catch (Exception e) {
                LOG.debug("Unable to stop the watch client", (Throwable)e);
            }
            finally {
                this.wsClient = null;
            }
        }

        public void onOpen(WebSocket webSocket, Response response) {
            if (this.open.compareAndSet(false, true)) {
                this.wsClient = webSocket;
                this.listener.onOpen();
            }
        }

        public void onClosing(WebSocket socket, int code, String reason) {
            if (this.open.compareAndSet(true, false)) {
                this.listener.onClose(code, reason);
            }
        }

        public void onMessage(WebSocket socket, String message) {
            this.listener.onMessage(message);
        }

        public void onMessage(WebSocket webSocket, ByteString bytes) {
            this.listener.onMessage(bytes.utf8());
        }

        public void onFailure(WebSocket socket, Throwable t, Response response) {
            this.listener.onFailure(t);
        }
    }
}

