/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.jboss.aesh.console.AeshProcess;
import org.jboss.aesh.console.Console;
import org.jboss.aesh.console.ConsoleCallback;
import org.jboss.aesh.console.ConsoleOperation;
import org.jboss.aesh.console.Process;
import org.jboss.aesh.console.command.CommandOperation;
import org.jboss.aesh.terminal.Key;
import org.jboss.aesh.util.LoggerUtil;

public class ProcessManager {
    private Console console;
    private volatile Map<Integer, Process> processes;
    private ExecutorService executorService;
    private boolean doLogging;
    private int pidCounter = 1;
    private int foregroundProcess = -1;
    private Stack<Process> backgroundStack = new Stack();
    private static final Logger LOGGER = LoggerUtil.getLogger(ProcessManager.class.getName());

    public ProcessManager(Console console, boolean log) {
        this.console = console;
        this.doLogging = log;
        this.processes = new HashMap<Integer, Process>(20);
        this.executorService = Executors.newCachedThreadPool();
    }

    public void startNewProcess(ConsoleCallback callback, ConsoleOperation consoleOperation) {
        int currentProcess;
        AeshProcess process = new AeshProcess(this.pidCounter++, this, callback, consoleOperation);
        if (this.doLogging) {
            LOGGER.info("starting a new process: " + process + ", consoleOperation: " + consoleOperation);
        }
        if ((currentProcess = this.getCurrentForegroundProcess()) > 0) {
            LOGGER.warning("Cannot start new process since process: " + this.getProcessByPid(currentProcess) + " is running in the foreground.");
        } else {
            this.processes.put(process.getPID(), process);
            this.foregroundProcess = process.getPID();
            this.executorService.execute(process);
        }
    }

    private int getCurrentForegroundProcess() {
        return this.foregroundProcess;
    }

    private Process getProcessByPid(int pid) {
        return this.processes.get(pid);
    }

    public CommandOperation getInput(int pid) throws InterruptedException {
        if (this.foregroundProcess == pid) {
            return this.console.getInput();
        }
        return new CommandOperation(Key.UNKNOWN, new int[0]);
    }

    public String getInputLine(int pid) throws InterruptedException {
        if (this.foregroundProcess == pid) {
            return this.console.getInputLine();
        }
        return "";
    }

    public void putProcessInBackground(int pid) {
        Process p;
        if (this.foregroundProcess == pid) {
            if (this.doLogging) {
                LOGGER.info("Putting process: " + pid + " into the background.");
            }
            this.foregroundProcess = -1;
        } else if (this.getProcessByPid(pid) != null && (p = this.getProcessByPid(pid)).getStatus() == Process.Status.FOREGROUND) {
            if (this.doLogging) {
                LOGGER.warning("We have another process in the foreground: " + p + ", this should not happen!");
            }
            p.updateStatus(Process.Status.BACKGROUND);
        }
    }

    public void putProcessInForeground(int pid) {
        if (this.foregroundProcess == -1) {
            Process p = this.getProcessByPid(pid);
            if (p != null) {
                p.updateStatus(Process.Status.FOREGROUND);
                this.foregroundProcess = p.getPID();
            }
        } else {
            Process p = this.getProcessByPid(pid);
            if (p != null) {
                this.backgroundStack.push(this.getProcessByPid(pid));
            }
            if (this.doLogging) {
                LOGGER.info("We already have a process in the foreground: " + this.foregroundProcess + ", pushing: " + pid + " to background stack. Will be pulled when current process ends.");
            }
        }
    }

    public Process getCurrentProcess() {
        return this.getProcessByPid(this.foregroundProcess);
    }

    public boolean hasForegroundProcess() {
        return this.foregroundProcess > 0;
    }

    public boolean hasProcesses() {
        return !this.processes.isEmpty();
    }

    public void processHaveFinished(Process process) {
        if (this.doLogging) {
            LOGGER.info("process has finished: " + process);
        }
        this.processes.remove(process.getPID());
        if (process.getStatus() == Process.Status.FOREGROUND) {
            this.foregroundProcess = this.backgroundStack.isEmpty() ? -1 : this.backgroundStack.pop().getPID();
        }
        this.console.currentProcessFinished(process);
    }

    public void stop() {
        try {
            if (this.doLogging) {
                LOGGER.info("number of processes in list: " + this.processes.size());
            }
            this.processes.clear();
            this.executorService.shutdown();
            this.executorService.awaitTermination(5L, TimeUnit.MILLISECONDS);
            if (this.executorService.isTerminated() && this.doLogging) {
                LOGGER.info("Processes are cleaned up and finished...");
            }
            if (this.executorService.isShutdown() && this.doLogging) {
                LOGGER.info("Executor isShutdown..");
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

