/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.cl.populator;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jboss.aesh.cl.CommandLine;
import org.jboss.aesh.cl.internal.ProcessedOption;
import org.jboss.aesh.cl.parser.CommandLineParserException;
import org.jboss.aesh.cl.populator.CommandPopulator;
import org.jboss.aesh.cl.validator.OptionValidatorException;
import org.jboss.aesh.console.AeshContext;
import org.jboss.aesh.console.InvocationProviders;
import org.jboss.aesh.console.command.Command;

public class AeshCommandPopulator
implements CommandPopulator<Object, Command> {
    private final Object instance;

    public AeshCommandPopulator(Object instance) {
        this.instance = instance;
    }

    @Override
    public void populateObject(CommandLine<Command> line, InvocationProviders invocationProviders, AeshContext aeshContext, boolean validate) throws CommandLineParserException, OptionValidatorException {
        if (line.hasParserError()) {
            throw line.getParserException();
        }
        for (ProcessedOption option : line.getParser().getProcessedCommand().getOptions()) {
            if (line.hasOption(option.getName())) {
                line.getOption(option.getName()).injectValueIntoField(this.getObject(), invocationProviders, aeshContext, validate);
                continue;
            }
            if (option.getDefaultValues().size() > 0) {
                option.injectValueIntoField(this.getObject(), invocationProviders, aeshContext, validate);
                continue;
            }
            this.resetField(this.getObject(), option.getFieldName(), option.hasValue());
        }
        if (line.getArgument() != null && line.getArgument().getValues().size() > 0 || line.getParser().getProcessedCommand().getArgument() != null && line.getParser().getProcessedCommand().getArgument().getDefaultValues().size() > 0) {
            line.getArgument().injectValueIntoField(this.getObject(), invocationProviders, aeshContext, validate);
        } else if (line.getArgument() != null) {
            this.resetField(this.getObject(), line.getArgument().getFieldName(), true);
        }
    }

    private void resetField(Object instance, String fieldName, boolean hasValue) {
        try {
            Field field = this.getField(instance.getClass(), fieldName);
            if (!Modifier.isPublic(field.getModifiers())) {
                field.setAccessible(true);
            }
            if (field.getType().isPrimitive()) {
                if (Boolean.TYPE.isAssignableFrom(field.getType())) {
                    field.set(instance, false);
                } else if (Integer.TYPE.isAssignableFrom(field.getType())) {
                    field.set(instance, 0);
                } else if (Short.TYPE.isAssignableFrom(field.getType())) {
                    field.set(instance, 0);
                } else if (Character.TYPE.isAssignableFrom(field.getType())) {
                    field.set(instance, Character.valueOf('\u0000'));
                } else if (Byte.TYPE.isAssignableFrom(field.getType())) {
                    field.set(instance, 0);
                } else if (Long.TYPE.isAssignableFrom(field.getType())) {
                    field.set(instance, 0L);
                } else if (Float.TYPE.isAssignableFrom(field.getType())) {
                    field.set(instance, Float.valueOf(0.0f));
                } else if (Double.TYPE.isAssignableFrom(field.getType())) {
                    field.set(instance, 0.0);
                }
            } else if (!hasValue && field.getType().equals(Boolean.class)) {
                field.set(instance, Boolean.FALSE);
            } else {
                field.set(instance, null);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    private Field getField(Class clazz, String fieldName) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException nsfe) {
            if (clazz.getSuperclass() != null) {
                return this.getField(clazz.getSuperclass(), fieldName);
            }
            throw nsfe;
        }
    }

    @Override
    public Object getObject() {
        return this.instance;
    }
}

