/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.MetadataAwareCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.xsite.spi.SiteEntry;

public class IracPutKeyValueCommand
extends AbstractDataWriteCommand
implements MetadataAwareCommand {
    public static final byte COMMAND_ID = 28;
    private Object value;
    private Metadata metadata;
    private PrivateMetadata privateMetadata;
    private boolean successful = true;
    private boolean expiration;

    public IracPutKeyValueCommand() {
    }

    public IracPutKeyValueCommand(Object key, int segment, CommandInvocationId commandInvocationId, Object value, Metadata metadata, PrivateMetadata privateMetadata) {
        super(key, segment, FlagBitSets.IRAC_UPDATE, commandInvocationId);
        assert (privateMetadata != null);
        this.value = value;
        this.metadata = metadata;
        this.privateMetadata = privateMetadata;
    }

    @Override
    public PrivateMetadata getInternalMetadata() {
        return this.privateMetadata;
    }

    @Override
    public void setInternalMetadata(PrivateMetadata internalMetadata) {
        this.privateMetadata = internalMetadata;
    }

    @Override
    public PrivateMetadata getInternalMetadata(Object key) {
        assert (Objects.equals(this.key, key));
        return this.getInternalMetadata();
    }

    @Override
    public void setInternalMetadata(Object key, PrivateMetadata internalMetadata) {
        assert (Objects.equals(this.key, key));
        this.setInternalMetadata(internalMetadata);
    }

    @Override
    public byte getCommandId() {
        return 28;
    }

    @Override
    public boolean isSuccessful() {
        return this.successful;
    }

    @Override
    public boolean isConditional() {
        return false;
    }

    @Override
    public ValueMatcher getValueMatcher() {
        return ValueMatcher.MATCH_ALWAYS;
    }

    @Override
    public void setValueMatcher(ValueMatcher valueMatcher) {
    }

    @Override
    public void fail() {
        this.successful = false;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitIracPutKeyValueCommand(ctx, this);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.PRIMARY;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isRemove() {
        return this.value == null;
    }

    public SiteEntry<Object> createSiteEntry(String site) {
        return new SiteEntry<Object>(site, this.value, this.metadata);
    }

    public void updateCommand(SiteEntry<Object> siteEntry) {
        this.value = siteEntry.getValue();
        this.setMetadata(siteEntry.getMetadata());
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        output.writeObject(this.value);
        output.writeObject(this.metadata);
        CommandInvocationId.writeTo(output, this.commandInvocationId);
        output.writeObject(this.privateMetadata);
        UnsignedNumeric.writeUnsignedInt((DataOutput)output, (int)this.segment);
        output.writeBoolean(this.expiration);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.value = input.readObject();
        this.metadata = (Metadata)input.readObject();
        this.commandInvocationId = CommandInvocationId.readFrom(input);
        this.privateMetadata = (PrivateMetadata)input.readObject();
        this.segment = UnsignedNumeric.readUnsignedInt((DataInput)input);
        this.expiration = input.readBoolean();
        this.setFlagsBitSet(FlagBitSets.IRAC_UPDATE);
    }

    public boolean isExpiration() {
        return this.expiration;
    }

    public void setExpiration(boolean expiration) {
        this.expiration = expiration;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IracPutKeyValueCommand that = (IracPutKeyValueCommand)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.privateMetadata, that.privateMetadata);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value, this.metadata, this.privateMetadata);
    }

    @Override
    public String toString() {
        return "IracPutKeyValueCommand{key=" + this.key + ", value=" + this.value + ", metadata=" + this.metadata + ", privateMetadata=" + this.privateMetadata + ", successful=" + this.successful + ", commandInvocationId=" + this.commandInvocationId + "}";
    }
}

