/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import java.util.function.Supplier;

public class LazyValue<T> {
    private final Supplier<T> supplier;
    private volatile transient T value;

    public LazyValue(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        T valueCopy = this.value;
        if (valueCopy != null) {
            return valueCopy;
        }
        LazyValue lazyValue = this;
        synchronized (lazyValue) {
            if (this.value == null) {
                this.value = this.supplier.get();
            }
            return this.value;
        }
    }

    public T getIfPresent() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LazyValue lazyValue = this;
        synchronized (lazyValue) {
            this.value = null;
        }
    }

    public boolean isSet() {
        return this.value != null;
    }
}

