/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod;

import java.util.Map;
import java.util.Objects;
import java.util.Spliterators;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.Search;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.ExpirableEntity;
import org.keycloak.models.map.common.StringKeyConverter;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelEntityUtil;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.chm.ConcurrentHashMapCrudOperations;
import org.keycloak.models.map.storage.chm.ConcurrentHashMapKeycloakTransaction;
import org.keycloak.models.map.storage.chm.MapFieldPredicates;
import org.keycloak.models.map.storage.hotRod.IckleQueryMapModelCriteriaBuilder;
import org.keycloak.models.map.storage.hotRod.common.AbstractHotRodEntity;
import org.keycloak.models.map.storage.hotRod.common.HotRodEntityDelegate;
import org.keycloak.models.map.storage.hotRod.common.HotRodEntityDescriptor;
import org.keycloak.models.map.storage.hotRod.common.HotRodUtils;
import org.keycloak.models.map.storage.hotRod.transaction.AllAreasHotRodTransactionsWrapper;
import org.keycloak.models.map.storage.hotRod.transaction.NoActionHotRodTransactionWrapper;
import org.keycloak.storage.SearchableModelField;
import org.keycloak.utils.StreamsUtil;

public class HotRodMapStorage<K, E extends AbstractHotRodEntity, V extends AbstractEntity & HotRodEntityDelegate<E>, M>
implements MapStorage<V, M>,
ConcurrentHashMapCrudOperations<V, M> {
    private static final Logger LOG = Logger.getLogger(HotRodMapStorage.class);
    private final RemoteCache<K, E> remoteCache;
    protected final StringKeyConverter<K> keyConverter;
    protected final HotRodEntityDescriptor<E, V> storedEntityDescriptor;
    private final Function<E, V> delegateProducer;
    protected final DeepCloner cloner;
    protected boolean isExpirableEntity;
    private final AllAreasHotRodTransactionsWrapper txWrapper;

    public HotRodMapStorage(RemoteCache<K, E> remoteCache, StringKeyConverter<K> keyConverter, HotRodEntityDescriptor<E, V> storedEntityDescriptor, DeepCloner cloner, AllAreasHotRodTransactionsWrapper txWrapper) {
        this.remoteCache = remoteCache;
        this.keyConverter = keyConverter;
        this.storedEntityDescriptor = storedEntityDescriptor;
        this.cloner = cloner;
        this.delegateProducer = storedEntityDescriptor.getHotRodDelegateProvider();
        this.isExpirableEntity = ExpirableEntity.class.isAssignableFrom(ModelEntityUtil.getEntityType(storedEntityDescriptor.getModelTypeClass()));
        this.txWrapper = txWrapper;
    }

    public V create(V value) {
        Long lifespan;
        Object key = this.keyConverter.fromStringSafe(value.getId());
        if (key == null) {
            key = this.keyConverter.yieldNewUniqueKey();
            value = this.cloner.from(this.keyConverter.keyToString(key), value);
        }
        if (this.isExpirableEntity && (lifespan = this.getLifespan(value)) != null) {
            if (lifespan > 0L) {
                this.remoteCache.putIfAbsent(key, (Object)((AbstractHotRodEntity)((HotRodEntityDelegate)value).getHotRodEntity()), lifespan.longValue(), TimeUnit.MILLISECONDS);
            } else {
                LOG.warnf("Skipped creation of entity %s in storage due to negative/zero lifespan.", key);
            }
            return value;
        }
        this.remoteCache.putIfAbsent(key, (Object)((AbstractHotRodEntity)((HotRodEntityDelegate)value).getHotRodEntity()));
        return value;
    }

    public V read(String key) {
        Objects.requireNonNull(key, "Key must be non-null");
        Object k = this.keyConverter.fromStringSafe(key);
        AbstractHotRodEntity hotRodEntity = (AbstractHotRodEntity)this.remoteCache.get(k);
        if (hotRodEntity == null) {
            return null;
        }
        return (V)((AbstractEntity)this.delegateProducer.apply(hotRodEntity));
    }

    public V update(V value) {
        Long lifespan;
        Object key = this.keyConverter.fromStringSafe(value.getId());
        if (this.isExpirableEntity && (lifespan = this.getLifespan(value)) != null) {
            AbstractHotRodEntity previousValue;
            if (lifespan > 0L) {
                previousValue = (AbstractHotRodEntity)this.remoteCache.replace(key, (Object)((AbstractHotRodEntity)((HotRodEntityDelegate)value).getHotRodEntity()), lifespan.longValue(), TimeUnit.MILLISECONDS);
            } else {
                LOG.warnf("Removing entity %s from storage due to negative/zero lifespan.", key);
                previousValue = (AbstractHotRodEntity)this.remoteCache.remove(key);
            }
            return (V)(previousValue == null ? null : (AbstractEntity)this.delegateProducer.apply(previousValue));
        }
        AbstractHotRodEntity previousValue = (AbstractHotRodEntity)this.remoteCache.replace(key, (Object)((AbstractHotRodEntity)((HotRodEntityDelegate)value).getHotRodEntity()));
        return (V)(previousValue == null ? null : (AbstractEntity)this.delegateProducer.apply(previousValue));
    }

    public boolean delete(String key) {
        Object k = this.keyConverter.fromStringSafe(key);
        return this.remoteCache.remove(k) != null;
    }

    private static String toOrderString(QueryParameters.OrderBy<?> orderBy) {
        SearchableModelField field = orderBy.getModelField();
        String modelFieldName = IckleQueryMapModelCriteriaBuilder.getFieldName(field);
        String orderString = orderBy.getOrder().equals((Object)QueryParameters.Order.ASCENDING) ? "ASC" : "DESC";
        return modelFieldName + " " + orderString;
    }

    public Stream<V> read(QueryParameters<M> queryParameters) {
        IckleQueryMapModelCriteriaBuilder iqmcb = (IckleQueryMapModelCriteriaBuilder)queryParameters.getModelCriteriaBuilder().flashToModelCriteriaBuilder(this.createCriteriaBuilder());
        Object queryString = iqmcb.getIckleQuery();
        if (!queryParameters.getOrderBy().isEmpty()) {
            queryString = (String)queryString + " ORDER BY " + queryParameters.getOrderBy().stream().map(HotRodMapStorage::toOrderString).collect(Collectors.joining(", "));
        }
        LOG.tracef("Executing read Ickle query: %s", queryString);
        QueryFactory queryFactory = Search.getQueryFactory(this.remoteCache);
        Query query = HotRodUtils.paginateQuery(queryFactory.create((String)queryString), queryParameters.getOffset(), queryParameters.getLimit());
        query.setParameters(iqmcb.getParameters());
        CloseableIterator iterator = query.iterator();
        return ((Stream)StreamsUtil.closing(StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), false)).onClose(() -> ((CloseableIterator)iterator).close())).filter(Objects::nonNull).map(this.delegateProducer);
    }

    public long getCount(QueryParameters<M> queryParameters) {
        IckleQueryMapModelCriteriaBuilder iqmcb = (IckleQueryMapModelCriteriaBuilder)queryParameters.getModelCriteriaBuilder().flashToModelCriteriaBuilder(this.createCriteriaBuilder());
        String queryString = iqmcb.getIckleQuery();
        LOG.tracef("Executing count Ickle query: %s", (Object)queryString);
        QueryFactory queryFactory = Search.getQueryFactory(this.remoteCache);
        Query query = queryFactory.create(queryString);
        query.setParameters(iqmcb.getParameters());
        return query.execute().hitCount().orElse(0L);
    }

    public long delete(QueryParameters<M> queryParameters) {
        IckleQueryMapModelCriteriaBuilder iqmcb = (IckleQueryMapModelCriteriaBuilder)queryParameters.getModelCriteriaBuilder().flashToModelCriteriaBuilder(this.createCriteriaBuilder());
        String queryString = "DELETE " + iqmcb.getIckleQuery();
        if (!queryParameters.getOrderBy().isEmpty()) {
            queryString = queryString + " ORDER BY " + queryParameters.getOrderBy().stream().map(HotRodMapStorage::toOrderString).collect(Collectors.joining(", "));
        }
        LOG.tracef("Executing delete Ickle query: %s", (Object)queryString);
        QueryFactory queryFactory = Search.getQueryFactory(this.remoteCache);
        if (queryParameters.getLimit() != null || queryParameters.getOffset() != null) {
            throw new IllegalArgumentException("HotRod storage does not support pagination for delete query");
        }
        Query query = queryFactory.create(queryString);
        query.setParameters(iqmcb.getParameters());
        return query.executeStatement();
    }

    public boolean exists(String key) {
        Objects.requireNonNull(key, "Key must be non-null");
        Object k = this.keyConverter.fromStringSafe(key);
        return this.remoteCache.containsKey(k);
    }

    public IckleQueryMapModelCriteriaBuilder<E, M> createCriteriaBuilder() {
        return new IckleQueryMapModelCriteriaBuilder(this.storedEntityDescriptor.getEntityTypeClass());
    }

    public MapKeycloakTransaction<V, M> createTransaction(KeycloakSession session) {
        return new NoActionHotRodTransactionWrapper((ConcurrentHashMapKeycloakTransaction)this.txWrapper.getOrCreateTxForModel(this.storedEntityDescriptor.getModelTypeClass(), () -> this.createTransactionInternal(session)));
    }

    protected MapKeycloakTransaction<V, M> createTransactionInternal(KeycloakSession session) {
        Map fieldPredicates = MapFieldPredicates.getPredicates(this.storedEntityDescriptor.getModelTypeClass());
        return new ConcurrentHashMapKeycloakTransaction((ConcurrentHashMapCrudOperations)this, this.keyConverter, this.cloner, fieldPredicates);
    }

    private Long getLifespan(V value) {
        Long expiration = ((ExpirableEntity)value).getExpiration();
        return expiration != null ? Long.valueOf(expiration - Time.currentTimeMillis()) : null;
    }
}

