/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.mpmetrics;

import io.quarkus.arc.ArcInvocationContext;
import io.quarkus.micrometer.runtime.binder.mpmetrics.MetricRegistryAdapter;
import io.quarkus.micrometer.runtime.binder.mpmetrics.MpMetadata;
import javax.annotation.Priority;
import javax.interceptor.AroundConstruct;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.annotation.Counted;

@Counted
@Interceptor
@Priority(value=1010)
class CountedInterceptor {
    final MetricRegistryAdapter mpRegistry;

    CountedInterceptor(MetricRegistryAdapter mpRegistry) {
        this.mpRegistry = mpRegistry;
    }

    @AroundConstruct
    Object countedConstructor(ArcInvocationContext context) throws Exception {
        return this.increment(context, context.getConstructor().getDeclaringClass().getSimpleName());
    }

    @AroundInvoke
    Object countedMethod(ArcInvocationContext context) throws Exception {
        return this.increment(context, context.getMethod().getName());
    }

    Object increment(ArcInvocationContext context, String methodName) throws Exception {
        Counted annotation = (Counted)context.findIterceptorBinding(Counted.class);
        if (annotation != null) {
            MpMetadata metadata = new MpMetadata(annotation.name().replace("<method>", methodName), annotation.description().replace("<method>", methodName), annotation.unit(), MetricType.COUNTER);
            this.mpRegistry.interceptorCounter(metadata, annotation.tags()).inc();
        }
        return context.proceed();
    }
}

