/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.kafka;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.binder.kafka.KafkaStreamsMetrics;
import io.quarkus.runtime.ShutdownEvent;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import org.apache.kafka.streams.KafkaStreams;
import org.jboss.logging.Logger;

@ApplicationScoped
public class KafkaStreamsEventObserver {
    private static final Logger log = Logger.getLogger(KafkaStreamsEventObserver.class);
    final MeterRegistry registry = Metrics.globalRegistry;
    KafkaStreamsMetrics kafkaStreamsMetrics;

    public synchronized void kafkaStreamsCreated(@Observes KafkaStreams kafkaStreams) {
        if (this.kafkaStreamsMetrics == null) {
            this.kafkaStreamsMetrics = new KafkaStreamsMetrics(kafkaStreams);
            try {
                this.kafkaStreamsMetrics.bindTo(this.registry);
            }
            catch (Throwable t) {
                log.warnf(t, "Unable to register metrics for KafkaStreams %s", (Object)kafkaStreams);
                this.tryToClose((AutoCloseable)this.kafkaStreamsMetrics);
            }
        } else {
            this.tryToClose((AutoCloseable)this.kafkaStreamsMetrics);
        }
    }

    void onStop(@Observes ShutdownEvent event) {
        this.tryToClose((AutoCloseable)this.kafkaStreamsMetrics);
    }

    void tryToClose(AutoCloseable c) {
        try {
            c.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

