/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.serial;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import org.jboss.marshalling.MarshallerObjectInputStream;
import org.jboss.marshalling.reflect.SerializableClass;
import org.jboss.marshalling.serial.BlockUnmarshaller;
import org.jboss.marshalling.serial.PlainDescriptor;
import org.jboss.marshalling.serial.SerialUnmarshaller;

final class SerialObjectInputStream
extends MarshallerObjectInputStream {
    private final SerialUnmarshaller serialUnmarshaller;
    private PlainDescriptor currentDescriptor;
    private SerializableClass currentSerializableClass;
    private Object currentSubject;
    private State state = State.OFF;

    SerialObjectInputStream(SerialUnmarshaller serialUnmarshaller) throws IOException, SecurityException {
        super(serialUnmarshaller.getBlockUnmarshaller());
        this.serialUnmarshaller = serialUnmarshaller;
    }

    PlainDescriptor saveCurrentDescriptor(PlainDescriptor currentDescriptor) {
        try {
            PlainDescriptor plainDescriptor = this.currentDescriptor;
            return plainDescriptor;
        }
        finally {
            this.currentDescriptor = currentDescriptor;
        }
    }

    void setCurrentDescriptor(PlainDescriptor currentDescriptor) {
        this.currentDescriptor = currentDescriptor;
    }

    Object saveCurrentSubject(Object currentSubject) {
        try {
            Object object = this.currentSubject;
            return object;
        }
        finally {
            this.currentSubject = currentSubject;
        }
    }

    void setCurrentSubject(Object currentSubject) {
        this.currentSubject = currentSubject;
    }

    SerializableClass saveCurrentSerializableClass(SerializableClass currentSerializableClass) {
        try {
            SerializableClass serializableClass = this.currentSerializableClass;
            return serializableClass;
        }
        finally {
            this.currentSerializableClass = currentSerializableClass;
        }
    }

    void setCurrentSerializableClass(SerializableClass currentSerializableClass) {
        this.currentSerializableClass = currentSerializableClass;
    }

    State saveState() {
        try {
            State state = this.state;
            return state;
        }
        finally {
            this.state = State.NEW;
        }
    }

    State restoreState(State state) {
        try {
            State state2 = this.state;
            return state2;
        }
        finally {
            this.state = state;
        }
    }

    @Override
    public void defaultReadObject() throws IOException, ClassNotFoundException {
        if (this.state != State.NEW) {
            throw new IllegalStateException("Fields may not be read now");
        }
        BlockUnmarshaller blockUnmarshaller = this.serialUnmarshaller.getBlockUnmarshaller();
        int cnt = blockUnmarshaller.available();
        if (cnt == -1) {
            blockUnmarshaller.unblock();
        }
        this.state = State.ON;
        this.currentDescriptor.defaultReadFields(this.serialUnmarshaller, this.currentSubject);
        if (cnt == -1) {
            blockUnmarshaller.endOfStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectInputStream.GetField readFields() throws IOException, ClassNotFoundException {
        if (this.state != State.NEW) {
            throw new IllegalStateException("Fields may not be read now");
        }
        BlockUnmarshaller blockUnmarshaller = this.serialUnmarshaller.getBlockUnmarshaller();
        int cnt = blockUnmarshaller.available();
        if (cnt == -1) {
            blockUnmarshaller.unblock();
        }
        this.state = State.ON;
        try {
            ObjectInputStream.GetField getField = this.currentDescriptor.getField(this.serialUnmarshaller, this.currentSerializableClass);
            return getField;
        }
        finally {
            if (cnt == -1) {
                blockUnmarshaller.endOfStream();
            }
        }
    }

    @Override
    public void registerValidation(ObjectInputValidation obj, int prio) throws NotActiveException, InvalidObjectException {
        this.serialUnmarshaller.addValidation(obj, prio);
    }

    static enum State {
        OFF,
        NEW,
        ON;

    }
}

