/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.aesh.command.Command;
import org.aesh.command.CommandException;
import org.aesh.command.CommandNotFoundException;
import org.aesh.command.CommandResult;
import org.aesh.command.Executable;
import org.aesh.command.Execution;
import org.aesh.command.container.CommandContainer;
import org.aesh.command.impl.AeshCommandRuntime;
import org.aesh.command.impl.internal.OptionType;
import org.aesh.command.impl.internal.ParsedCommand;
import org.aesh.command.impl.internal.ProcessedCommand;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.operator.AndOperator;
import org.aesh.command.impl.operator.AppendOutputRedirectionOperator;
import org.aesh.command.impl.operator.ConfigurationOperator;
import org.aesh.command.impl.operator.DataProvider;
import org.aesh.command.impl.operator.EndOperator;
import org.aesh.command.impl.operator.ExecutableOperator;
import org.aesh.command.impl.operator.InputDelegate;
import org.aesh.command.impl.operator.InputRedirectionOperator;
import org.aesh.command.impl.operator.Operator;
import org.aesh.command.impl.operator.OrOperator;
import org.aesh.command.impl.operator.OutputRedirectionOperator;
import org.aesh.command.impl.operator.PipeOperator;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.invocation.CommandInvocationConfiguration;
import org.aesh.command.operator.OperatorType;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.result.ResultHandler;
import org.aesh.command.validator.CommandValidatorException;
import org.aesh.command.validator.OptionValidatorException;
import org.aesh.io.PipelineResource;
import org.aesh.io.Resource;
import org.aesh.parser.ParsedLine;
import org.aesh.readline.AeshContext;
import org.aesh.readline.Prompt;
import org.aesh.selector.Selector;

class Executions {
    Executions() {
    }

    static <CI extends CommandInvocation> List<Execution<CI>> buildExecution(List<ParsedLine> fullLine, AeshCommandRuntime<CI> runtime) throws CommandNotFoundException, CommandLineParserException, IOException {
        CommandInvocationConfiguration invocationConfiguration;
        State state = State.NEED_COMMAND;
        CommandContainer<CI> processedCommand = null;
        ConfigurationOperator config = null;
        DataProvider dataProvider = null;
        InputDelegate inDelegate = null;
        ArrayList<Execution<CI>> executions = new ArrayList<Execution<CI>>();
        for (ParsedLine pl : fullLine) {
            boolean newParsedLine = false;
            if (!pl.hasWords()) {
                throw new CommandLineParserException(pl.errorMessage());
            }
            while (!newParsedLine) {
                switch (state) {
                    case NEED_COMMAND: {
                        processedCommand = runtime.findCommandContainer(pl);
                        state = State.NEED_OPERATOR;
                        break;
                    }
                    case NEED_ARGUMENT: {
                        if (config == null) {
                            throw new IllegalArgumentException("Invalid " + pl.line());
                        }
                        config.setArgument(pl.firstWord().word());
                        state = State.NEED_OPERATOR;
                        break;
                    }
                    case NEED_OPERATOR: {
                        OperatorType ot = pl.operator();
                        Operator op = Executions.buildOperator(pl.operator(), runtime.getAeshContext());
                        if (ot.isConfiguration()) {
                            if (config != null) {
                                if (config.getConfiguration().getInputRedirection() == null) {
                                    throw new IllegalArgumentException("Invalid operators structure");
                                }
                                inDelegate = config.getConfiguration().getInputRedirection();
                            }
                            config = (ConfigurationOperator)op;
                        }
                        if (ot.isConfiguration() && ot.hasArgument()) {
                            state = State.NEED_ARGUMENT;
                        } else {
                            if (!(op instanceof ExecutableOperator)) {
                                throw new IllegalArgumentException("Op " + (Object)((Object)ot) + " is not executable");
                            }
                            if (processedCommand == null) {
                                throw new IllegalArgumentException("Invalid command line, command is missing.");
                            }
                            ExecutableOperator exec = (ExecutableOperator)op;
                            invocationConfiguration = config == null ? new CommandInvocationConfiguration(runtime.getAeshContext(), dataProvider) : new CommandInvocationConfiguration(runtime.getAeshContext(), config.getConfiguration().getOutputRedirection(), inDelegate == null ? config.getConfiguration().getInputRedirection() : inDelegate, dataProvider);
                            ExecutionImpl<CI> execution = new ExecutionImpl<CI>(exec, runtime, invocationConfiguration, processedCommand);
                            dataProvider = exec instanceof DataProvider ? (DataProvider)((Object)exec) : null;
                            executions.add(execution);
                            config = null;
                            inDelegate = null;
                            state = State.NEED_COMMAND;
                        }
                        newParsedLine = true;
                        break;
                    }
                }
            }
        }
        if (state == State.NEED_OPERATOR) {
            ExecutableOperator exec = (ExecutableOperator)Executions.buildOperator(OperatorType.NONE, runtime.getAeshContext());
            invocationConfiguration = config == null ? new CommandInvocationConfiguration(runtime.getAeshContext(), dataProvider) : config.getConfiguration();
            ExecutionImpl<CI> execution = new ExecutionImpl<CI>(exec, runtime, invocationConfiguration, processedCommand);
            executions.add(execution);
        }
        return executions;
    }

    private static Operator buildOperator(OperatorType op, AeshContext context) {
        if (op == null) {
            return null;
        }
        switch (op) {
            case NONE: 
            case END: {
                return new EndOperator();
            }
            case REDIRECT_OUT: {
                return new OutputRedirectionOperator(context);
            }
            case APPEND_OUT: {
                return new AppendOutputRedirectionOperator(context);
            }
            case PIPE: {
                return new PipeOperator(context);
            }
            case REDIRECT_IN: {
                return new InputRedirectionOperator(context);
            }
            case AND: {
                return new AndOperator();
            }
            case OR: {
                return new OrOperator();
            }
        }
        throw new IllegalArgumentException("Unsupported operator " + (Object)((Object)op));
    }

    private static enum State {
        NEED_COMMAND,
        NEED_OPERATOR,
        NEED_ARGUMENT;

    }

    private static class ExecutionImpl<T extends CommandInvocation>
    implements Execution<T> {
        private final ExecutableOperator<T> executable;
        private ProcessedCommand<Command<T>, T> cmd;
        private final CommandInvocationConfiguration invocationConfiguration;
        private final AeshCommandRuntime<T> runtime;
        private final CommandContainer<T> commandContainer;
        private CommandResult result;
        private boolean populated;

        ExecutionImpl(ExecutableOperator<T> executable, AeshCommandRuntime<T> runtime, CommandInvocationConfiguration invocationConfiguration, CommandContainer<T> commandContainer) {
            this.executable = executable;
            this.runtime = runtime;
            this.invocationConfiguration = invocationConfiguration;
            this.commandContainer = commandContainer;
            this.cmd = commandContainer.getParser().getProcessedCommand();
        }

        @Override
        public T getCommandInvocation() {
            return this.runtime.buildCommandInvocation(this.invocationConfiguration, this.commandContainer);
        }

        @Override
        public Executable getExecutable() {
            return this.executable;
        }

        @Override
        public Command<T> getCommand() {
            return this.cmd.getCommand();
        }

        @Override
        public void populateCommand() throws CommandLineParserException, OptionValidatorException {
            if (!this.populated) {
                this.cmd = this.commandContainer.parseAndPopulate(this.runtime.invocationProviders(), this.runtime.getAeshContext());
                this.populated = true;
            }
        }

        @Override
        public ResultHandler getResultHandler() {
            return this.cmd.resultHandler();
        }

        @Override
        public CommandResult execute() throws CommandException, InterruptedException, CommandValidatorException, CommandLineParserException, OptionValidatorException {
            this.populateCommand();
            this.executable.setCommand(this.cmd.getCommand());
            if (this.cmd.validator() != null && !this.cmd.hasOptionWithOverrideRequired()) {
                this.cmd.validator().validate(this.getCommand());
            }
            if (this.cmd.getActivator() != null && !this.cmd.getActivator().isActivated(new ParsedCommand(this.cmd))) {
                this.result = CommandResult.FAILURE;
                throw new CommandException("The command is not available in the current context.");
            }
            if (this.hasRedirectIn()) {
                this.updateInjectedArgumentWithRedirectedInData();
                if (this.invocationConfiguration.getPipedData() != null) {
                    this.result = CommandResult.FAILURE;
                    throw new CommandException("Can't inject both from input and pipe operators");
                }
            }
            if (this.invocationConfiguration.getPipedData() != null) {
                this.updateInjectedArgumentWithPipelinedData(new PipelineResource(this.invocationConfiguration.getPipedData()));
                if (this.hasRedirectIn()) {
                    this.result = CommandResult.FAILURE;
                    throw new CommandException("Can't inject both from input and pipe operators");
                }
            }
            if (this.cmd.hasAskIfNotSet()) {
                for (ProcessedOption option : this.cmd.getAllAskIfNotSet()) {
                    try {
                        if (option.getOptionType().equals((Object)OptionType.ARGUMENT) || option.getOptionType().equals((Object)OptionType.ARGUMENTS)) {
                            option.addValue(this.getCommandInvocation().getShell().readLine(new Prompt("Argument(s) is not set, please provide a value: ")));
                        } else {
                            option.addValue(this.getCommandInvocation().getShell().readLine(new Prompt("Option " + option.name() + ", is not set, please provide a value: ")));
                        }
                        this.runtime.populateAskedOption(option);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (this.cmd.hasSelector()) {
                for (ProcessedOption option : this.cmd.getAllSelectors()) {
                    option.addValues(new Selector(option.selectorType(), option.getDefaultValues(), option.description()).doSelect(this.getCommandInvocation().getShell()));
                    this.runtime.populateAskedOption(option);
                }
            }
            try {
                this.result = this.executable.execute(this.getCommandInvocation());
                if (this.getResultHandler() != null) {
                    if (this.result == null || this.result.equals(CommandResult.SUCCESS)) {
                        this.getResultHandler().onSuccess();
                    } else {
                        this.getResultHandler().onFailure(this.result);
                    }
                }
                if (this.result == null) {
                    this.result = CommandResult.SUCCESS;
                }
            }
            catch (CommandException ex) {
                this.result = CommandResult.FAILURE;
                throw ex;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                this.result = CommandResult.FAILURE;
                throw ex;
            }
            catch (Exception e) {
                this.result = CommandResult.FAILURE;
                throw new RuntimeException(e);
            }
            finally {
                if (this.invocationConfiguration.getOutputRedirection() != null) {
                    try {
                        this.invocationConfiguration.getOutputRedirection().close();
                    }
                    catch (IOException ex) {
                        throw new CommandException(ex);
                    }
                }
            }
            return this.result;
        }

        private void updateInjectedArgumentWithPipelinedData(PipelineResource resource) {
            ProcessedOption arg = this.checkProcessedCommandForResourceArgument();
            if (arg != null) {
                arg.injectResource(resource, this.cmd.getCommand());
            }
        }

        private boolean hasRedirectIn() {
            return this.invocationConfiguration.getInputRedirection() != null;
        }

        private void updateInjectedArgumentWithRedirectedInData() {
            ProcessedOption arg = this.checkProcessedCommandForResourceArgument();
            if (arg != null) {
                arg.injectResource(new PipelineResource(this.invocationConfiguration.getInputRedirection().read()), this.cmd.getCommand());
            }
        }

        private ProcessedOption checkProcessedCommandForResourceArgument() {
            if (this.cmd.hasArguments() && Resource.class.isAssignableFrom(this.cmd.getArguments().type())) {
                return this.cmd.getArguments();
            }
            if (this.cmd.hasArgument() && Resource.class.isAssignableFrom(this.cmd.getArgument().type())) {
                return this.cmd.getArgument();
            }
            return null;
        }

        @Override
        public CommandResult getResult() {
            return this.result;
        }

        @Override
        public void setResut(CommandResult result) {
            this.result = result;
        }

        @Override
        public void clearQueuedLine() {
            this.commandContainer.emptyLine();
        }
    }
}

