/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Properties;
import org.keycloak.theme.PropertiesUtil;
import org.keycloak.theme.Theme;

public class FolderTheme
implements Theme {
    private String parentName;
    private String importName;
    private File themeDir;
    private File resourcesDir;
    private String name;
    private Theme.Type type;
    private final Properties properties;

    public FolderTheme(File themeDir, String name, Theme.Type type) throws IOException {
        this.themeDir = themeDir;
        this.name = name;
        this.type = type;
        this.properties = new Properties();
        File propertiesFile = new File(themeDir, "theme.properties");
        if (propertiesFile.isFile()) {
            Charset encoding = PropertiesUtil.detectEncoding(new FileInputStream(propertiesFile));
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(propertiesFile), encoding);){
                this.properties.load(reader);
            }
            this.parentName = this.properties.getProperty("parent");
            this.importName = this.properties.getProperty("import");
        }
        this.resourcesDir = new File(themeDir, "resources");
    }

    public String getName() {
        return this.name;
    }

    public String getParentName() {
        return this.parentName;
    }

    public String getImportName() {
        return this.importName;
    }

    public Theme.Type getType() {
        return this.type;
    }

    public URL getTemplate(String name) throws IOException {
        File file = new File(this.themeDir, name);
        return file.isFile() ? file.toURI().toURL() : null;
    }

    public InputStream getResourceAsStream(String path) throws IOException {
        File file;
        if (File.separatorChar != '/') {
            path = path.replace('/', File.separatorChar);
        }
        if (!(file = new File(this.resourcesDir, path)).isFile() || !file.getCanonicalPath().startsWith(this.resourcesDir.getCanonicalPath() + File.separator)) {
            return null;
        }
        return file.toURI().toURL().openStream();
    }

    public Properties getMessages(Locale locale) throws IOException {
        return this.getMessages("messages", locale);
    }

    public Properties getMessages(String baseBundlename, Locale locale) throws IOException {
        if (locale == null) {
            return null;
        }
        Properties m = new Properties();
        File file = new File(this.themeDir, "messages" + File.separator + baseBundlename + "_" + locale.toString() + ".properties");
        if (file.isFile()) {
            Charset encoding = PropertiesUtil.detectEncoding(new FileInputStream(file));
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), encoding);){
                m.load(reader);
            }
        }
        return m;
    }

    public Properties getProperties() {
        return this.properties;
    }
}

