/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiFunction;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.theme.Theme;
import org.keycloak.utils.StringUtil;

public class AdminMessageFormatter
implements BiFunction<String, Object[], String> {
    private final Locale locale;
    private final Properties messages;

    public AdminMessageFormatter(KeycloakSession session, UserModel user) {
        try {
            KeycloakContext context = session.getContext();
            this.locale = context.resolveLocale(user);
            this.messages = new Properties();
            this.messages.putAll((Map<?, ?>)this.getTheme(session).getMessages(this.locale));
            RealmModel realm = context.getRealm();
            if (StringUtil.isNotBlank((String)realm.getDefaultLocale())) {
                this.messages.putAll((Map<?, ?>)realm.getRealmLocalizationTextsByLocale(realm.getDefaultLocale()));
            }
            this.messages.putAll((Map<?, ?>)realm.getRealmLocalizationTextsByLocale(this.locale.toLanguageTag()));
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to configure error messages", cause);
        }
    }

    private Theme getTheme(KeycloakSession session) throws IOException {
        return session.theme().getTheme(Theme.Type.ADMIN);
    }

    @Override
    public String apply(String s, Object[] objects) {
        return new MessageFormat(this.messages.getProperty(s, s), this.locale).format(objects);
    }
}

